Name: pcre
Version: 8.43
Release: alt1

Summary: Perl-compatible regular expression library
License: BSD-style
Group: System/Libraries
Url: http://www.pcre.org/

# ftp://ftp.csx.cam.ac.uk/pub/software/programming/pcre/pcre-%version.tar.bz2
Source: pcre-%version.tar
Source1: pcre-config.1

Patch: pcre-%version-%release.patch

Summary(ru_RU.UTF-8): Библиотека для работы с Perl-совместимыми регулярными выражениями

%define libname libpcre3
%def_enable cpp
%def_disable jit

BuildRequires: gcc-c++ libreadline-devel

%package -n %libname
Summary: Perl-compatible regular expression shared library
Summary(ru_RU.UTF-8): Разделяемая библиотека для работы с регулярными выражениями Perl-стиля
Group: System/Libraries
Provides: pcre-config(utf8)
Provides: pcre-config(unicode-properties)
Provides: %name = %version
Obsoletes: %name < %version

%package -n libpcre16
Summary: Perl-compatible regular expression shared library with UTF-16 support
Summary(ru_RU.UTF-8): Разделяемая библиотека для работы с регулярными выражениями Perl-стиля с поддержкой UTF-16
Group: System/Libraries
Provides: pcre-config(utf16)

%package -n lib%name-devel
Summary: Perl-compatible regular expressions development environment
Summary(ru_RU.UTF-8): Заголовочные файлы и документация для разработки с использованием библиотеки PCRE
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel < %version
Requires: %libname = %version-%release
Requires: libpcre16 = %version-%release
Requires: pcretest = %version-%release

%package -n lib%name-devel-static
Summary: Perl-compatible regular expressions static library
Summary(ru_RU.UTF-8): Вариант библиотеки PCRE для статической компоновки
Group: Development/C
Provides: %name-devel-static = %version
Obsoletes: %name-devel-static < %version
Requires: lib%name-devel = %version-%release

%package -n lib%{name}cpp3
Summary: Perl-compatible regular expressions C++ wrapper shared library
Summary(ru_RU.UTF-8): Разделяемая библиотека для работы с регулярными выражениями Perl-стиля на C++
Group: System/Libraries
Provides: lib%{name}cpp = %version
Requires: %libname = %version-%release

%package -n lib%{name}cpp-devel
Summary: Perl-compatible regular expressions C++ wrapper development library and header files
Summary(ru_RU.UTF-8): Заголовочные файлы и библиотека для разработки на C++ с использованием PCRE
Group: Development/C
Requires: lib%{name}cpp3 = %version-%release, lib%name-devel = %version-%release

%package -n pcretest
Summary: A program for testing Perl-compatible regular expressions
Group: Development/Other
Requires: %libname = %version-%release
Requires: libpcre16 = %version-%release

%description
The PCRE library is a set of functions that implement regular expression
pattern matching using the same syntax and semantics as Perl, with
just a few differences.  The current implementation of PCRE corresponds
approximately with Perl 5.8.

%description -l ru_RU.UTF-8
Библиотека PCRE (Perl-compatible regular expressions) предоставляет
набор функций для работы с регулярными выражениями, синтаксис и смысл
которых полностью совпадают со встроенными регулярными выражениями
языка Perl версии 5.8.

%description -n %libname
The PCRE library is a set of functions that implement regular expression
pattern matching using the same syntax and semantics as Perl, with
just a few differences.  The current implementation of PCRE corresponds
approximately with Perl 5.8.

This package contains PCRE runtime shared libraries.

%description -n %libname -l ru_RU.UTF-8
Библиотека PCRE (Perl-compatible regular expressions) предоставляет
набор функций для работы с регулярными выражениями, синтаксис и смысл
которых полностью совпадают со встроенными регулярными выражениями
языка Perl версии 5.8.

Данный пакет содержит динамическую разделяемую библиотеку PCRE.

%description -n libpcre16
The PCRE library is a set of functions that implement regular expression
pattern matching using the same syntax and semantics as Perl, with
just a few differences.  The current implementation of PCRE corresponds
approximately with Perl 5.8.

This package contains libpcre16 runtime dhared library.

%description -n libpcre16 -l ru_RU.UTF-8
Библиотека PCRE (Perl-compatible regular expressions) предоставляет
набор функций для работы с регулярными выражениями, синтаксис и смысл
которых полностью совпадают со встроенными регулярными выражениями
языка Perl версии 5.8.

Данный пакет содержит динамическую разделяемую библиотеку libpcre16.

%description -n lib%{name}cpp3
The PCRE library is a set of functions that implement regular expression
pattern matching using the same syntax and semantics as Perl, with
just a few differences.  The current implementation of PCRE corresponds
approximately with Perl 5.8.

This package contains PCRE C++ wrapper shared library.

%description -n lib%{name}cpp3 -l ru_RU.UTF-8
Библиотека PCRE (Perl-compatible regular expressions) предоставляет набор
функций для работы с регулярными выражениями, синтаксис и смысл которых
полностью совпадают со встроенными регулярными выражениями языка Perl
версии 5.8.

Данный пакет содержит динамическую разделяемую библиотеку PCRE для C++.

%description -n lib%name-devel
The PCRE library is a set of functions that implement regular expression
pattern matching using the same syntax and semantics as Perl, with
just a few differences.  The current implementation of PCRE corresponds
approximately with Perl 5.8.

This package contains development libraries, include files and development
documentation required for developing applications which use perl-style
regular expressions.

%description -n lib%name-devel -l ru_RU.UTF-8
Библиотека PCRE (Perl-compatible regular expressions) предоставляет набор
функций для работы с регулярными выражениями, синтаксис и смысл которых
полностью совпадают со встроенными регулярными выражениями языка Perl
версии 5.8.

Данный пакет содержит средства разработки: заголовочные файлы и
документацию, необходимые для написания и сборки программ, использующих
библиотеку PCRE.

%description -n lib%{name}cpp-devel
The PCRE library is a set of functions that implement regular expression
pattern matching using the same syntax and semantics as Perl, with
just a few differences.  The current implementation of PCRE corresponds
approximately with Perl 5.8.

This package contains development libraries, include files and development
documentation required for developing C++ applications which use
perl-style regular expressions.

%description -n lib%{name}cpp-devel -l ru_RU.UTF-8
Библиотека PCRE (Perl-compatible regular expressions) предоставляет набор
функций для работы с регулярными выражениями, синтаксис и смысл которых
полностью совпадают со встроенными регулярными выражениями языка Perl
версии 5.8.

Данный пакет содержит средства разработки: заголовочные файлы и
документацию, необходимые для написания и сборки программ на C++,
использующих библиотеку PCRE.

%description -n lib%name-devel-static
The PCRE library is a set of functions that implement regular expression
pattern matching using the same syntax and semantics as Perl, with
just a few differences.  The current implementation of PCRE corresponds
approximately with Perl 5.8.

This package contains static development libraries required for developing
statically linked applications which use perl-style regular expressions.

%description -n lib%name-devel-static -l ru_RU.UTF-8
Библиотека PCRE (Perl-compatible regular expressions) предоставляет набор
функций для работы с регулярными выражениями, синтаксис и смысл которых
полностью совпадают со встроенными регулярными выражениями языка Perl
версии 5.8.

Данный пакет содержит библиотеку для статической компоновки программ,
использующих функции PCRE.

%description -n pcretest
pcretest is a program for testing Perl-compatible regular expressions.
It was written as a test program for the PCRE regular expression library
itself, but it can also be  used for experimenting with Perl-compatible
regular expressions.

%prep
%setup
%patch -p1

rm aclocal.m4 m4/{libtool,lt*}.m4

%build
%autoreconf
%define docdir %_docdir/%name-%version
%configure --includedir=%_includedir/%name \
	--docdir=%docdir \
	--enable-pcre8 \
	--enable-pcre16 \
	--enable-utf \
	--enable-unicode-properties \
	--enable-pcretest-libreadline \
	%{subst_enable cpp} \
	%{subst_enable jit} \
	#
%make_build

%install
%makeinstall_std

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir %buildroot/%_lib
for f in %buildroot%_libdir/libpcre{,posix}.so; do
	if t=$(readlink "$f"); then
		ln -sf ../../%_lib/"$t" "$f"
	fi
done
mv %buildroot%_libdir/libpcre{,posix}.so.* %buildroot/%_lib/

install -pm644 %_sourcedir/pcre-config.1 %buildroot%_man1dir/

bzip2 -9 %buildroot%docdir/ChangeLog
install -pm644 HACKING pcredemo.c %buildroot%docdir/

rm %buildroot%_bindir/pcregrep
rm %buildroot%_man1dir/pcregrep.*
rm %buildroot%_libdir/*.la

%check
%make_build check

%files -n %libname
/%_lib/libpcre.so.*
/%_lib/libpcreposix.so.*
%dir %docdir
%docdir/[ACLN]*

%files -n libpcre16
%_libdir/libpcre16.so.*

%files -n lib%name-devel
%_libdir/libpcre.so
%_libdir/libpcre16.so
%_libdir/libpcreposix.so
%_includedir/pcre
%_bindir/*
%_pkgconfigdir/libpcre.pc
%_pkgconfigdir/libpcre16.pc
%_pkgconfigdir/libpcreposix.pc
%_man1dir/*
%_man3dir/*
%exclude %_bindir/pcretest
%exclude %_man1dir/pcretest.*
%if_enabled cpp
%exclude %_includedir/pcre/pcrecpp*.h
%exclude %_includedir/pcre/pcre_*.h
%exclude %_man3dir/pcrecpp.*
%endif #cpp
%dir %docdir
%docdir/H*
%docdir/*.c
%docdir/*.txt
%docdir/html
%exclude %docdir/README

%if_enabled cpp
%files -n lib%{name}cpp3
%_libdir/libpcrecpp.so.*

%files -n lib%{name}cpp-devel
%_libdir/libpcrecpp.so
%dir %_includedir/pcre
%_includedir/pcre/pcrecpp*.h
%_includedir/pcre/pcre_*.h
%_pkgconfigdir/libpcrecpp.pc
%_man3dir/pcrecpp.*
%endif #cpp

%files -n lib%name-devel-static
%_libdir/*.a

%files -n pcretest
%_bindir/pcretest
%_man1dir/pcretest.*

%changelog
