Epoch: 0
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
Name:           pdfbox
Version:        1.8.10
Release:        alt1_1jpp8
Summary:        Java library for working with PDF documents
License:        ASL 2.0
URL:            http://pdfbox.apache.org/
Source0:        http://www.apache.org/dist/pdfbox/%{version}/%{name}-%{version}-src.zip
#Don't download anything
Patch0:         %{name}-nodownload.patch
#Use sysytem bitream-vera-sans-fonts instead of bundled fonts
Patch1:         %{name}-1.2.0-bitstream.patch

Patch2:         pdfbox-1.8.10-port-to-bouncycastle1.50.patch

BuildRequires:  fonts-ttf-vera
BuildRequires:  fontconfig
BuildRequires:  maven-local >= 4.3.2
BuildRequires:  maven-local
BuildRequires:  mvn(com.adobe.pdf:pcfi)
BuildRequires:  mvn(com.ibm.icu:icu4j)
BuildRequires:  mvn(commons-logging:commons-logging)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(log4j:log4j:1.2.17)
BuildRequires:  mvn(org.apache.ant:ant)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-antrun-plugin)
BuildRequires:  mvn(org.apache.rat:apache-rat-plugin)
BuildRequires:  mvn(org.bouncycastle:bcmail-jdk15on)
BuildRequires:  mvn(org.codehaus.mojo:javacc-maven-plugin)

BuildArch:      noarch

Requires:       fonts-ttf-vera
Source44: import.info

%description
Apache PDFBox is an open source Java PDF library for working with PDF
documents. This project allows creation of new PDF documents, manipulation of
existing documents and the ability to extract content from documents. Apache
PDFBox also includes several command line utilities. Apache PDFBox is
published under the Apache License v2.0.

%package examples
Group: Development/Java
Summary:        Examples for %{name}

%description examples
This package contains examples for %{name}.

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%package ant
Group: Development/Java
Summary:        Apache PDFBox for Ant

%description ant
%{summary}.

%package -n fontbox
Group: Development/Java
Summary:        Apache FontBox

%description -n fontbox
FontBox is a Java library used to obtain low level information from font
files. FontBox is a subproject of Apache PDFBox.

%package -n jempbox
Group: Development/Java
Summary:        Apache JempBox

%description -n jempbox
JempBox is an open source Java library that implements Adobe's XMP(TM)
specification. JempBox is a subproject of Apache PDFBox.

%package -n preflight
Group: Development/Java
Summary:        Apache Preflight

%description -n preflight
The Apache Preflight library is an open source Java tool that implements 
a parser compliant with the ISO-19005 (PDF/A) specification. Preflight is a 
subproject of Apache PDFBox.

%package -n xmpbox
Group: Development/Java
Summary:        Apache XmpBox

%description -n xmpbox
The Apache XmpBox library is an open source Java tool that implements Adobe's
XMP(TM) specification.  It can be used to parse, validate and create xmp
contents.  It is mainly used by subproject preflight of Apache PDFBox. 
XmpBox is a subproject of Apache PDFBox.

%prep
%setup -q
find -name '*.class' -delete
find -name '*.jar' -delete

%patch0 -p1 -b .nodownload
%patch1 -p1 -b .bitstream
%patch2 -p1 -b .bouncycastle1.50

%pom_disable_module war
#Disable lucene, not compatible with lucene 3.6
%pom_disable_module lucene
# Don't build app (it's just a bundle of everything)
%pom_disable_module preflight-app
%pom_disable_module app

# cobertura-maven-plugin has been retired
%pom_remove_plugin :cobertura-maven-plugin preflight
%pom_remove_dep javax.activation:activation preflight

%pom_change_dep -r :ant-nodeps :ant
%pom_xpath_set -r "pom:dependency[pom:artifactId = 'log4j']/pom:version" 1.2.17

#Fix line endings
sed -i -e 's|\r||' RELEASE-NOTES.txt
#Remove META-INF file that does not exist

#Use jdk15on version of bcprov
%pom_change_dep -r :bcmail-jdk15 :bcmail-jdk15on:1.50
%pom_change_dep -r :bcprov-jdk15 :bcprov-jdk15on:1.50
%pom_add_dep org.bouncycastle:bcpkix-jdk15on:1.50 %{name}

sed -i -e '/META-INF/d' pdfbox/pom.xml
#Remove included fonts
rm -r pdfbox/src/main/resources/org/apache/pdfbox/resources/ttf

# TODO
rm -rf examples/src/main/java/org/apache/pdfbox/examples/signature/CreateSignature.java \
 examples/src/main/java/org/apache/pdfbox/examples/signature/CreateVisibleSignature.java \
 examples/src/test/java/org/apache/pdfbox/examples/pdfa/CreatePDFATest.java
# IllegalArgumentException: Parameter 'directory' is not a directory
rm -r preflight/src/test/java/org/apache/pdfbox/preflight/integration/TestValidFiles.java

# Skip testImageIOUtils
# https://issues.apache.org/jira/browse/PDFBOX-2084
sed -i -e "/TestImageIOUtils.java/d" pdfbox/pom.xml
# Remove unpackaged deps for the above tests
%pom_remove_dep net.java.dev.jai-imageio:jai-imageio-core-standalone pdfbox
# https://bugzilla.redhat.com/show_bug.cgi?id=1094417
%pom_remove_dep com.levigo.jbig2:levigo-jbig2-imageio pdfbox
rm -rf pdfbox/src/test/java/org/apache/pdfbox/util/TestImageIOUtils.java \
 pdfbox/src/test/java/org/apache/pdfbox/pdmodel/graphics/xobject/PDJpegTest.java \
 pdfbox/src/test/java/org/apache/pdfbox/pdmodel/graphics/xobject/PDCcittTest.java
sed -i -e /PDJpegTest/d pdfbox/src/test/java/org/apache/pdfbox/TestAll.java
sed -i -e /PDCcittTest/d pdfbox/src/test/java/org/apache/pdfbox/TestAll.java
sed -i -e /TestImageIOUtils/d pdfbox/src/test/java/org/apache/pdfbox/TestAll.java

# Disable filtering
sed -i -e /filtering/d examples/pom.xml

# install all libraries in _javadir
# NOTE: current guideline require all libraries must be installed in _javadir/%%name when JARs are > 2
%mvn_file :jempbox jempbox
%mvn_file :%{name} %{name}
%mvn_file :%{name}-ant %{name}-ant
%mvn_file :%{name}-examples %{name}-examples
%mvn_file :preflight preflight
%mvn_file :xmpbox xmpbox
%mvn_file :fontbox fontbox

# Merge paret poms in main package
%mvn_package :%{name} %{name}
%mvn_package :%{name}-parent %{name}
%mvn_package :%{name}-reactor %{name}

%mvn_package :%{name}-ant %{name}-ant
%mvn_package :%{name}-examples %{name}-examples
%mvn_package :fontbox fontbox
%mvn_package :jempbox jempbox
%mvn_package :preflight preflight
%mvn_package :xmpbox xmpbox

%build

%mvn_build -- -Dadobefiles.jar=$(build-classpath pcfi)

%install
%mvn_install

#TODO - install/ship war

%files -f .mfiles-%{name}
%doc README.txt RELEASE-NOTES.txt
%doc LICENSE.txt NOTICE.txt

%files examples -f .mfiles-%{name}-examples
%doc LICENSE.txt NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt NOTICE.txt

%files ant -f .mfiles-%{name}-ant
%doc LICENSE.txt NOTICE.txt

%files -n fontbox -f .mfiles-fontbox
%doc LICENSE.txt NOTICE.txt

%files -n jempbox -f .mfiles-jempbox
%doc LICENSE.txt NOTICE.txt

%files -n preflight -f .mfiles-preflight
%doc LICENSE.txt NOTICE.txt

%files -n xmpbox -f .mfiles-xmpbox
%doc LICENSE.txt NOTICE.txt

%changelog
