%global majver  2
%global minver  08

Name:           pdfjam
Version:        %majver.%minver
Release:        alt1
Summary:        Utilities for joining, rotating and aligning PDFs

Group:          Publishing
License:        GPLv2
URL:            http://go.warwick.ac.uk/pdfjam
Source:         http://go.warwick.ac.uk/pdfjam/pdfjam_%{majver}%{minver}.tgz
BuildArch:      noarch

# Automatically added by buildreq on Fri Sep 16 2011
BuildRequires: unzip

BuildPreReq: texlive-latex-recommended /proc

Requires: texlive-latex-recommended

%description
PDFjam is a small collection of shell scripts which provide a simple
interface to some of the functionality of the excellent pdfpages
package (by Andreas Matthias) for pdfLaTeX.  At present the utilities
available are:

  * pdfnup, which allows PDF files to be "n-upped" in roughly the way
    that psnup does for PostScript files;
  * pdfjoin, which concatenates the pages of multiple PDF files
    together into a single file;
  * pdf90, which rotates the pages of one or more PDF files through 90
    degrees (anti-clockwise).

In every case, source files are left unchanged.

A potential drawback of these utilities is that any hyperlinks in the
source PDF are lost. On the positive side, there is no appreciable
degradation of image quality in processing PDF files with these
programs, unlike some other indirect methods such as "pdf2ps | psnup |
ps2pdf" (in the author's experience).


%prep
%setup -q -n pdfjam
unzip tests.zip

%build

%install

install -d -m 755 %buildroot{%_bindir,%_mandir/man1}
install -p -m 755 bin/* %buildroot%_bindir/
install -p -m 644 man1/* %buildroot%_mandir/man1/

%check
cd tests
./run.sh | tee testlog.txt
[ `grep ^OK testlog.txt | wc -l` == 5 ]


%files
%doc COPYING PDFjam-README.html pdfdroplets.png pdfjam.conf
%_bindir/*
%_mandir/man1/*


%changelog
