%global backends %{nil}
%define _pkgdocdir %_docdir/%name

Name: pdns
Version: 4.0.3
Release: alt1.M80P.1
Summary: A modern, advanced and high performance authoritative-only nameserver
Group: System/Servers
License: GPLv2
URL: http://powerdns.com
Source0: %{name}-%{version}.tar
Source1: pdns.service
Patch0: pdns-disable-secpoll.patch
Patch1: fix-unit-tests-32bit.patch
Patch2: fix-negative-ipv6-32bit.patch

Requires(pre): shadow-utils
Requires(post): systemd-units

BuildRequires: gcc-c++ boost-program_options-devel curl libsqlite3-devel
BuildRequires: systemd-devel
BuildRequires: boost-devel
BuildRequires: liblua5-devel
BuildRequires: bison
BuildRequires: libzeromq-devel
BuildRequires: openssl-devel
BuildRequires: libprotobuf-devel
BuildRequires: protobuf-compiler
Provides: powerdns = %{version}-%{release}
%global backends %{backends} bind

%description
The PowerDNS Nameserver is a modern, advanced and high performance
authoritative-only nameserver. It is written from scratch and conforms
to all relevant DNS standards documents.
Furthermore, PowerDNS interfaces with almost any database.

%package tools
Summary: Extra tools for %{name}
Group: System/Servers

%description tools
This package contains the extra tools for %{name}

%package backend-mysql
Summary: MySQL backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
BuildRequires: libmysqlclient-devel
%global backends %{backends} gmysql

%description backend-mysql
This package contains the gmysql backend for %{name}

%package backend-postgresql
Summary: PostgreSQL backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
BuildRequires: postgresql-devel
%global backends %{backends} gpgsql

%description backend-postgresql
This package contains the gpgsql backend for %{name}

%package backend-pipe
Summary: Pipe backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
%global backends %{backends} pipe

%description backend-pipe
This package contains the pipe backend for %{name}

%package backend-remote
Summary: Remote backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
%global backends %{backends} remote

%description backend-remote
This package contains the remote backend for %{name}

%package backend-ldap
Summary: LDAP backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
BuildRequires: openldap-devel
%global backends %{backends} ldap

%description backend-ldap
This package contains the ldap backend for %{name}

%package backend-lua
Summary: LUA backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
%global backends %{backends} lua

%description backend-lua
This package contains the lua backend for %{name}

%package backend-sqlite
Summary: SQLite backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
BuildRequires: sqlite-devel
%global backends %{backends} gsqlite3

%description backend-sqlite
This package contains the SQLite backend for %{name}

%package backend-opendbx
Summary: OpenDBX backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
BuildRequires: opendbx-devel
%global backends %{backends} opendbx

%description backend-opendbx
This package contains the opendbx backend for %{name}

%package backend-geoip
Summary: GeoIP backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
BuildRequires: libGeoIP-devel
BuildRequires: libyaml-cpp-devel
%global backends %{backends} geoip

%description backend-geoip
This package contains the GeoIP backend for %{name}

%package backend-mydns
Summary: MyDNS backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
%global backends %{backends} mydns

%description backend-mydns
This package contains the MyDNS backend for %{name}

%package backend-tinydns
Summary: TinyDNS backend for %{name}
Group: System/Servers
Requires: %{name}%{?_isa} = %{version}-%{release}
BuildRequires: tinycdb-devel
%global backends %{backends} tinydns

%description backend-tinydns
This package contains the TinyDNS backend for %{name}

%prep
%setup -q
%patch0 -p1 -b .disable-secpoll
%patch1 -p1 -b .fix-unit-tests-32bit
%patch2 -p1 -b .fix-negative-ipv6-32bit

%build
export CPPFLAGS="-DLDAP_DEPRECATED"

%configure \
	--sysconfdir=%{_sysconfdir}/%{name} \
	--disable-static \
	--disable-dependency-tracking \
	--disable-silent-rules \
	--with-modules='' \
	--with-lua \
	--with-dynmodules='%{backends}' \
	--enable-tools \
	--enable-remotebackend-zeromq \
	--enable-unit-tests \
	--enable-reproducible

make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}

%{__rm} -f %{buildroot}%{_libdir}/%{name}/*.la
%{__mv} %{buildroot}%{_sysconfdir}/%{name}/pdns.conf{-dist,}

chmod 600 %{buildroot}%{_sysconfdir}/%{name}/pdns.conf

# rename zone2ldap to pdns-zone2ldap (#1193116)
%{__mv} %{buildroot}/%{_bindir}/zone2ldap %{buildroot}/%{_bindir}/pdns_zone2ldap
%{__mv} %{buildroot}/%{_mandir}/man1/zone2ldap.1 %{buildroot}/%{_mandir}/man1/pdns_zone2ldap.1

# Copy systemd service file
install -p -D -m 644 %{SOURCE1} %{buildroot}%{_unitdir}/pdns.service

# change user/group to pdns
# change default backend to bind
sed -i \
    -e 's/# setuid=/setuid=pdns/' \
    -e 's/# setgid=/setgid=pdns/' \
    -e 's/# launch=/launch=bind/' \
    %{buildroot}%{_sysconfdir}/%{name}/pdns.conf

%{__rm} %{buildroot}/%{_bindir}/stubquery

#%%check
#make %{?_smp_mflags} -C pdns check

%pre
getent group pdns >/dev/null || groupadd -r pdns
getent passwd pdns >/dev/null || \
	useradd -r -g pdns -d / -s /sbin/nologin \
	-c "PowerDNS user" pdns
exit 0

%post
%post_service pdns

%preun
%preun_service pdns

%files
%doc COPYING README
%{_bindir}/pdns_control
%{_bindir}/pdnsutil
%{_bindir}/pdns_zone2ldap
%{_bindir}/zone2sql
%{_bindir}/zone2json
%{_sbindir}/pdns_server
%{_mandir}/man1/pdns_control.1.*
%{_mandir}/man1/pdns_server.1.*
%{_mandir}/man1/zone2sql.1.*
%{_mandir}/man1/zone2json.1.*
%{_mandir}/man1/pdns_zone2ldap.1.*
%{_mandir}/man1/pdnsutil.1.*
%{_unitdir}/pdns.service
%{_libdir}/%{name}/libbindbackend.so
%dir %{_libdir}/%{name}/
%dir %{_sysconfdir}/%{name}/
%config(noreplace) %{_sysconfdir}/%{name}/pdns.conf

%files tools
%{_bindir}/calidns
%{_bindir}/dnsbulktest
%{_bindir}/dnsgram
%{_bindir}/dnspcap2protobuf
%{_bindir}/dnsreplay
%{_bindir}/dnsscan
%{_bindir}/dnsscope
%{_bindir}/dnstcpbench
%{_bindir}/dnswasher
%{_bindir}/dumresp
%{_bindir}/ixplore
%{_bindir}/pdns_notify
%{_bindir}/nproxy
%{_bindir}/nsec3dig
%{_bindir}/saxfr
%{_bindir}/sdig
%{_mandir}/man1/calidns.1.*
%{_mandir}/man1/dnsbulktest.1.*
%{_mandir}/man1/dnsgram.1.*
%{_mandir}/man1/dnspcap2protobuf.1.*
%{_mandir}/man1/dnsreplay.1.*
%{_mandir}/man1/dnsscan.1.*
%{_mandir}/man1/dnsscope.1.*
%{_mandir}/man1/dnstcpbench.1.*
%{_mandir}/man1/dnswasher.1.*
%{_mandir}/man1/dumresp.1.*
%{_mandir}/man1/ixplore.1.*
%{_mandir}/man1/pdns_notify.1.*
%{_mandir}/man1/nproxy.1.*
%{_mandir}/man1/nsec3dig.1.*
%{_mandir}/man1/saxfr.1.*
%{_mandir}/man1/sdig.1.*

%files backend-mysql
%{_pkgdocdir}/schema.mysql.sql
%{_pkgdocdir}/dnssec-3.x_to_3.4.0_schema.mysql.sql
%{_pkgdocdir}/nodnssec-3.x_to_3.4.0_schema.mysql.sql
%{_libdir}/%{name}/libgmysqlbackend.so

%files backend-postgresql
%{_pkgdocdir}/schema.pgsql.sql
%{_pkgdocdir}/dnssec-3.x_to_3.4.0_schema.pgsql.sql
%{_pkgdocdir}/nodnssec-3.x_to_3.4.0_schema.pgsql.sql
%{_libdir}/%{name}/libgpgsqlbackend.so

%files backend-pipe
%{_libdir}/%{name}/libpipebackend.so

%files backend-remote
%{_libdir}/%{name}/libremotebackend.so

%files backend-ldap
%{_libdir}/%{name}/libldapbackend.so

%files backend-lua
%{_libdir}/%{name}/libluabackend.so

%files backend-sqlite
%{_pkgdocdir}/schema.sqlite3.sql
%{_pkgdocdir}/dnssec-3.x_to_3.4.0_schema.sqlite3.sql
%{_pkgdocdir}/nodnssec-3.x_to_3.4.0_schema.sqlite3.sql
%{_libdir}/%{name}/libgsqlite3backend.so

%files backend-opendbx
%{_libdir}/%{name}/libopendbxbackend.so

%files backend-geoip
%{_libdir}/%{name}/libgeoipbackend.so

%files backend-mydns
%{_pkgdocdir}/schema.mydns.sql
%{_libdir}/%{name}/libmydnsbackend.so

%files backend-tinydns
%{_libdir}/%{name}/libtinydnsbackend.so

%changelog
