%define module	MRO-Compat
%define name	perl-%{module}
%define version 0.12

Name:		%{name}
Version:	0.12
Release:	alt1
Summary:	mro::* interface compatibility for Perls < 5.9.5
URL:		http://search.cpan.org/dist/%{module}
Source:		http://www.cpan.org/authors/id/B/BO/BOBTFISH/MRO-Compat-%{version}.tar.gz
License:	GPL
Group:		Development/Perl
# Automatically added by buildreq on Fri Nov 13 2009 (-bi)
BuildRequires: perl-Class-C3 perl-Module-Install perl-Test-Pod perl-Test-Pod-Coverage

BuildRequires:	perl-devel
BuildRequires:	perl-Module-Install
BuildRequires:	perl-Class-C3
BuildRequires:	perl-Class-C3-XS
Provides:	perl(mro.pm)
BuildArch:	noarch
%add_findreq_skiplist mro.pm


%description
The "mro" namespace provides several utilities for dealing with method
resolution order and method caching in general in Perl 5.9.5 and higher.

This module provides those interfaces for earlier versions of Perl (back to
5.6.0 anyways).

It is a harmless no-op to use this module on 5.9.5+. If you're writing a piece
of software that would like to use the parts of 5.9.5+'s mro:: interfaces that
are supported here, and you want compatibility with older Perls, this is the
module for you.

Some parts of this interface will work better with Class::C3::XS installed, but
it's not a requirement.

This module never exports any functions. All calls must be fully qualified with
the mro:: prefix.

The interface documentation here serves only as a quick reference of what the
function basically does, and what differences between MRO::Compat and 5.9.5+
one should look out for. The main docs in 5.9.5's mro are the real interface
docs, and contain a lot of other

%prep
%setup -q -n %{module}-%{version}

%build
#{__perl} Makefile.PL INSTALLDIRS=vendor
#make
#make test
%perl_vendor_build

%install
#make_install DESTDOR=%buildroot install 
%perl_vendor_install


#files
#defattr(-,root,root)
#doc ChangeLog README
#{perl_vendorlib}/MRO
#{_mandir}/*/*


%files
%perl_vendor_privlib/*
%exclude %perl_vendor_archlib


%changelog
