# SPEC file for Perl module PDF::API2

Name: perl-PDF-API2
Version: 2.027
Release: alt1

Summary: Perl module for creation and modification PDF files
Summary(ru_RU.UTF-8): модуль Perl для создания и изменения файлов PDF

License: %lgpl2plus
Group: Development/Perl
URL: http://search.cpan.org/dist/PDF-API2/

Packager: Nikolay A. Fetisov <naf@altlinux.ru>

%define real_name PDF-API2
Source: %real_name-%version.tar
Patch0: %real_name-2.019-alt-fix_fonts_path.patch
Patch1: %real_name-0.51-alt-Lbrk_pl.patch

BuildArch: noarch

BuildRequires(pre): perl-devel rpm-build-licenses

# Automatically added by buildreq on Sun Sep 14 2014
# optimized out: perl-Compress-Raw-Zlib perl-Encode perl-IO-Compress perl-Pod-Escapes perl-Pod-Simple perl-Unicode-Normalize perl-devel
BuildRequires: perl-Font-TTF perl-Math-Complex perl-Test-Pod perl-unicore

%description
PDF::API2 is a Perl module to facilitate the creation and
modification of high-quality "Portable Document Format"
(PDF) files. PDF::API2:
- works with more than one PDF file open at once;
- presents an object-oriented API to the user;
- supports the 14 base PDF Core Fonts, subset of PDF CJK Fonts, 
  Adobe Type1 (.pfa/pfb), TrueType (.ttf) and OpenType (.ttf/otf)
  fonts;
- supports images in JPEG, PND, GIF, TIFF, PBM, PGM, PPM formats;
- supports EAN13, CODE39, CODE39EXT, CODE25INT, CODABAR barcodes;
- supports rudimentary modification and import from existing PDFs.

%description -l ru_RU.UTF-8
PDF::API2 - модуль  Perl для  создания и изменения файлов в
формате PDF (Portable Document Format). PDF::API2:
- позволяет одновременно работать с более чем одним открытым 
  файлом PDF;
- предоставляет пользователю объектно-ориентированный интерфейс;
- поддерживает 14 базовых шрифтов PDF, подмножество шрифтов CJK.
  шрифты Adobe Type1 (.pfa/pfb), TrueType (.ttf) и OpenType 
  (.ttf/otf);
- поддерживает работу с изображениями в форматах JPEG, PND, GIF, 
  TIFF, PBM, PGM и PPM;
- поддерживает штрихкоды в кодировках EAN13, CODE39, CODE39EXT, 
  CODE25INT, CODABAR;
- поддерживает простую модификацию и импорт из существующих 
  документов PDF.

%prep
%setup  -n %real_name-%version
%patch0
%patch1

mv -f -- LICENSE LICENSE.LGPL.orig
ln -s -- $(relative %_licensedir/LGPL %_docdir/%name/LICENSE) LICENSE

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README PATENTS
%doc contrib*
%doc --no-dereference LICENSE

%perl_vendor_privlib/PDF/API2*
%exclude /.perl.req

%changelog
