# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-devel perl-podlators
# END SourceDeps(oneline)
%define fedora 23
Name:		perl-Test-Warnings
Version:	0.026
Release:	alt1_2
Summary:	Test for warnings and the lack of them
License:	GPL+ or Artistic
Group:		Development/Perl
URL:		http://search.cpan.org/dist/Test-Warnings
Source0:	http://search.cpan.org/CPAN/authors/id/E/ET/ETHER/Test-Warnings-%{version}.tar.gz
BuildArch:	noarch
# Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	perl
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# Module
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(Test/Builder.pm)
BuildRequires:	perl(parent.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(if.pm)
BuildRequires:	perl(lib.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(Test/Tester.pm)
# Optional Tests
BuildRequires:	perl(CPAN/Meta.pm)
%if 0%{?fedora} || 0%{?rhel} > 7
BuildRequires:	perl(CPAN/Meta/Check.pm)
%endif
BuildRequires:	perl(CPAN/Meta/Prereqs.pm)
BuildRequires:	perl(CPAN/Meta/Requirements.pm)
BuildRequires:	perl(PadWalker.pm)
# Runtime
Requires:	perl(Carp.pm)
Source44: import.info

%description
If you've ever tried to use Test::NoWarnings to confirm there are no warnings
generated by your tests, combined with the convenience of done_testing to not
have to declare a test count, you'll have discovered that these two features do
not play well together, as the test count will be calculated before the
warnings test is run, resulting in a TAP error (see examples/test_nowarnings.pl
in this distribution for a demonstration).

This module is intended to be used as a drop-in replacement for
Test::NoWarnings: it also adds an extra test, but runs this test before
done_testing calculates the test count, rather than after. It does this by
hooking into done_testing as well as via an END block. You can declare a plan,
or not, and things will still Just Work.

It is actually equivalent to:

    use Test::NoWarnings 1.04 ':early';

as warnings are still printed normally as they occur. You are safe, and
enthusiastically encouraged, to perform a global search-replace of the above
with use Test::Warnings; whether or not your tests have a plan.

%prep
%setup -q -n Test-Warnings-%{version}

%build
perl Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor
make %{?_smp_mflags}

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
# %{_fixperms} %{buildroot}

%check
make test

%files
%doc LICENCE
%doc Changes CONTRIBUTING README examples/
%{perl_vendor_privlib}/Test/

%changelog
