Name: perl-xCAT
Version: 2.5.1
Release: alt0.4.2
License: EPL
Summary: xCAT perl libraries
Url: http://xcat.sourceforge.net/
Group: Development/Perl
Source: perl-xCAT-%{version}.tar
Packager: Andriy Stepanov <stanv@altlinux.ru>
BuildArch: noarch
BuildRequires: perl-DBI perl-Storable perl-Text-Balanced perl-XML-Simple perl-SNMP
BuildRequires: perl-Expect perl-libwww perl-SOAP-Lite
BuildRequires: perl-Math-BigInt
BuildRequires: perl-podlators
BuildRequires: perl-Digest-SHA1
BuildRequires: perl-HTML-Form

%description
Provides perl xCAT libraries for core functionality.  Required for all xCAT installations.
Includes xCAT::Table, xCAT::NodeRange, among others.

# XXX: stanv@
%add_findreq_skiplist %{perl_vendor_privlib}/xCAT/DSHCLI.pm
# XXX: stanv@ see bug: https://sourceforge.net/tracker/?func=detail&aid=2972471&group_id=208749&atid=1006945
%add_findreq_skiplist %{perl_vendor_privlib}/xCAT/Template.pm

%prep
%setup -q

%build

# Modify the Version() function in xCAT/Utils.pm to automatically have the correct version
./modifyUtils %{version}

# Build the pod version of the man pages for each DB table.  It puts them in the man5 and man7 subdirs.
# Then convert the pods to man pages and html pages.
./db2man

install -d -pm 755 %{buildroot}%{perl_vendor_privlib}/xCAT/data

install -D -pm 644 xCAT/*.pm      %{buildroot}%{perl_vendor_privlib}/xCAT

install -D -pm 644 xCAT/data/*.pm %{buildroot}%{perl_vendor_privlib}/xCAT/data

# These were built dynamically in the build phas
install -d -pm 755 %{buildroot}%{_man5dir}
install -d -pm 755 %{buildroot}%{_man7dir}

install -D -pm 644 share/man/man5/* %{buildroot}%{_man5dir}
install -D -pm 644 share/man/man7/* %{buildroot}%{_man7dir}

%files
%doc LICENSE.html README
%doc %_mandir/*/*
%{perl_vendor_privlib}/xCAT

%changelog
