%define gver 4.9
%set_gcc_version %gver

%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%def_disable docs

%define scalar_type complex
%if "%scalar_type" == "real"
%define alttype complex
%else
%define alttype real
%endif

%define oname petsc4py
%define ldir %_libdir/petsc-%scalar_type
Name: %oname-%scalar_type
Version: 3.5
%define exampledir %_docdir/%oname-%version/examples
Release: alt2.git20140906
Summary: PETSc for Python (%scalar_type scalars)
License: Public
Group: Sciences/Mathematics
Url: https://bitbucket.org/petsc/petsc4py
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://bitbucket.org/petsc/petsc4py.git
Source: %oname-%version.tar.gz

Requires: python-module-%name = %version-%release

BuildPreReq: python-devel python-module-Pyro4 chrpath rpm-macros-make
BuildPreReq: %mpiimpl-devel libpetsc-%scalar_type-devel libnumpy-devel
BuildPreReq: libmpe2-devel libhdf5-mpi-devel libtriangle-devel libX11-devel
BuildPreReq: liby12m-devel libsundials-devel libsz2-devel zlib-devel
BuildPreReq: libexpat-devel libtetgen-devel python-module-mpi4py
BuildPreReq: python-module-sphinx-devel python-module-Pygments
BuildPreReq: texlive-latex-base /usr/bin/ssh libdakota-devel
BuildPreReq: python-module-Cython gcc%gver-c++ gcc%gver-fortran libgomp-devel
%if "%scalar_type" == "complex"
BuildPreReq: libfftw3-mpi-devel
%endif
BuildPreReq: libamesos10 libepetraext10 libifpack10 libtrilinos10
BuildPreReq: libgaleri10
BuildPreReq: libamesos10-devel libepetraext10-devel libifpack10-devel

%description
Python bindings for PETSc (%scalar_type scalars).

%package -n python-module-%name
Summary: Python module with bindings for PETSc (%scalar_type scalars)
Group: Development/Python
%add_python_lib_path %ldir/python
%setup_python_module %oname
Provides: python%_python_version(%oname) = %version-%release
%py_provides %oname
#Requires: %name = %version-%release

%description -n python-module-%name
Python module with bindings for PETSc (%scalar_type scalars)

Note: for work with this module You need run:
source %_bindir/%name.sh

%package -n %oname-examples
Summary: Examples for Python bindings for PETSc
Group: Development/Documentation
BuildArch: noarch
Provides: %name-examples = %version-%release
Conflicts: %name-examples < %version-%release
Obsoletes: %name-examples < %version-%release

%description -n %oname-examples
Examples for Python bindings for PETSc.

%if_enabled docs

%package -n python-module-%name-pickles
Summary: Pickles for Python bindings for PETSc
Group: Development/Documentation
Provides: %name-examples = %version-%release
Conflicts: %name-examples < %version-%release
Obsoletes: %name-examples < %version-%release

%description -n python-module-%name-pickles
Pickles for Python bindings for PETSc.

%package -n %oname-doc
Summary: Documentation for Python bindings for PETSc
Group: Development/Documentation
BuildArch: noarch
Provides: %name-doc = %version-%release
Conflicts: %name-doc < %version-%release
Obsoletes: %name-doc < %version-%release

%description -n %oname-doc
Documentation for Python bindings for PETSc.

%endif

%prep
%setup

sed -i 's|@PYVER@|%_python_version|g' docs/source/Makefile
rm -f src/petsc4py.PETSc.c
#rm -f src/*.c

%install
mpi-selector --set %mpiimpl
source %_bindir/petsc-%scalar_type.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

#sed -i 's|@MPIDIR@|%mpidir|g' conf/core/confutils.py
#sed -i 's|@MPIIMPL@|%mpiimpl|g' conf/core/confutils.py
#sed -i "s|@PETSCDIR@|$PETSC_DIR|g" conf/core/confutils.py
#sed -i "s|@MPILIBS@||g" conf/core/confcore.py
%add_optflags %optflags_shared -fno-strict-aliasing
%add_optflags -I%ldir/include -I%mpidir/include -include petscviewerhdf5.h
#python_build
export CC=g++
%make_ext config
#make_ext cython
python ./conf/cythonize.py
for i in SNESPythonGetContext PCPythonGetContext \
	PetscPythonRegisterAll MatPythonGetContext \
	KSPPythonGetContext TSPythonGetContext
do
sed -i \
	"s|\(PetscErrorCode $i\)|extern \"C\" \1|" \
	src/libpetsc4py/libpetsc4py.c
done
sed -i \
	"s|\(int import_libpetsc4py\)|extern \"C\" \1|" \
	src/libpetsc4py/libpetsc4py.c
%make_build_ext

%if_enabled docs
ln -s build/html/objects.inv docs/source/
%make -C docs/source html
%endif

%python_install

install -d %buildroot%ldir/python
mv %buildroot%python_sitelibdir/* \
	%buildroot%ldir/python/
sed -i 's|^\(PETSC_ARCH\).*|\1 =|' \
	%buildroot%ldir/python/%oname/lib/petsc.cfg

%if_enabled docs
install -d %buildroot%_docdir/%oname-%version
cp -fR docs/source/_build/html \
	%buildroot%_docdir/%oname-%version/
install -d %buildroot%python_sitelibdir/%name
cp -fR docs/source/_build/pickle \
	%buildroot%python_sitelibdir/%name/
%endif

install -d %buildroot%exampledir
sed -i 's|@EXAMPLES@|%exampledir|g' demo/kspsolve/test_mat_*.py
cp -fR demo/* %buildroot%exampledir/

# example modules

#export PYTHONPATH=$PYTHONPATH:%buildroot%ldir/python
#pushd demo/bratu2d
#make_build_ext bratu2df90
#install -m644 *.so %buildroot%ldir/python
#popd

#pushd demo/poisson3d
#f2py -m del2lib -c del2lib.f90
#make_build_ext del2lib.so poisson3d
#install -m644 *.so %buildroot%ldir/python
#install -d %buildroot%ldir/bin
#install -m755 poisson3d %buildroot%ldir/bin
#popd

#for i in %buildroot%ldir/bin/poisson3d \
#	%buildroot%ldir/python/%oname/lib/PETSc.so
for i in %buildroot%ldir/python/%oname/lib/PETSc.so
do
	chrpath -r %mpidir/lib:%ldir/lib $i
done

#files
#ldir/bin/*

%files -n python-module-%name
%doc *.rst
%dir %ldir/python
%ldir/python/*

%if "%scalar_type" == "real"
%if_enabled docs
%files -n %oname-doc
%doc %dir %_docdir/%oname-%version
%doc %_docdir/%oname-%version/*
%exclude %_docdir/%oname-%version/examples
%endif

%files -n %oname-examples
%doc %dir %_docdir/%oname-%version
%doc %_docdir/%oname-%version/examples
%else
%exclude %_docdir/%oname-%version/examples
%if_enabled docs
%exclude %_docdir/%oname-%version/html
#exclude %_docdir/%oname-%version/*.pdf
%endif
%endif

%if_enabled docs
%files -n python-module-%name-pickles
%dir %python_sitelibdir/%name
%python_sitelibdir/%name/pickle
%endif

%changelog
