%define php5_sapi cli
%add_findreq_skiplist %_usrsrc/php5-devel/*

Summary: The PHP5 scripting language
Name:	 php5
Version: 5.6.38
Release: alt1%ubt

%define php5_name      %name
%define _php5_version  %version
%define _php5_major  5.6
%define _php5_snapshot 20180912
%define php5_release   %release
%define rpm_build_version %_php5_version%([ -z "%_php5_snapshot" ] || echo ".%_php5_snapshot")

License: PHP
Group:	 Development/Other
Url: http://www.php.net/
#Git: http://git.php.net/repository/php-src.git

Source0: php5-source.tar
Source1: phpver.rpm.macros.standalone
Source2: php-packaging.readme
Source3: php.ini
Source4: phpinfo.tar

Patch1: php-version.patch
Patch2: php-shared-1.patch
Patch3: php-cli-build.patch
Patch5: php-4.0.0-init.patch
Patch6: php-test-pcntl.patch
Patch9: php-5.3.3-sapi-scandir.patch

Patch12: php-devel-scripts-alternatives.patch
Patch13: php-4.3.11-dlopen.patch

Patch17: php-fix-headers-order.patch

Patch20: php-pcre-jit.patch

Patch30: php-4.3.11-libtool.patch
Patch32: php-5.2.1-umask.patch
Patch33: php-5.2.5-norpath.patch
Patch34: php-5.1.0b1-cxx.patch
Patch38: php-no-static-program.patch
Patch39: php-set-session-save-path.patch
Patch40: php5-5.2.13-alt-lsattr_path.patch
Patch41: php5-alt-checklibs.patch
Patch51: php-5.3.5-alt-build-gcc-version.patch
Patch60: php-%version-bison-pregenerated.patch
Patch61: php5-5.5.9-phar-phppath.patch
Patch62: php-mysqlnd-socket.patch
Patch63: php5-5.6-syms-visibility.patch
Patch64: php-7.1-alt-phar-manfile-suffix.patch
Patch65: php5-5.6.32-debian-use_embedded_timezonedb.patch
Patch66: php5-5.6.32-debian-use-system-timezone.patch

PreReq:  php5-libs = %version-%release
Requires(post):  php5-suhosin
Provides: php-engine = %version-%release
Provides: %name = %rpm_build_version-%release

BuildRequires: chrpath libmm-devel libxml2-devel ssmtp termutils zlib-devel re2c bison alternatives

BuildRequires(pre): rpm-build-php5 rpm-macros-alternatives
BuildRequires(pre): rpm-build-ubt

BuildRequires: libtool_1.5 chrpath
%set_libtool_version 1.5

%description
PHP5 is a widely-used general-purpose scripting language that is
especially suited for Web development and can be embedded into HTML.
The most common use of PHP coding is probably as a replacement
for CGI scripts.

%package -n rpm-build-php-version
Summary:	RPM helper macros to rebuild PHP5 packages

Group:		Development/Other
License:	GPL
BuildArch:	noarch

%description -n rpm-build-php-version
These helper macros provide possibility to rebuild
PHP5 packages by some Alt Linux Team Policy compatible way.

%package mysqlnd
Group: System/Servers
Summary: Native PHP driver for MySQL
Requires: php5 = %rpm_build_version-%php5_release
Provides: %name-mysqlnd = %rpm_build_version-%php5_release

%description mysqlnd
Native PHP driver for MySQL

%package devel
Group: Development/C
Summary: Development package for PHP5

Requires: php5-libs = %version-%release
Requires: rpm-build-php5
Requires: rpm-build-php-version = %version-%release
# for phpize
Requires: libtool, autoconf, automake

Provides: php-devel
Provides: %name-devel = %rpm_build_version-%release
Provides: php-engine-devel = %version-%release

%description devel
The php5-devel package lets you compile dynamic extensions to PHP5.
Instead of recompiling the whole php binary, install this package
and use the new self-contained extensions support. For more information,
read the file SELF-CONTAINED-EXTENSIONS.

%package libs
Group: Development/C
Summary: Package with common data for various PHP5 packages
Requires: php-base >= 2.5

Provides: php5-bcmath = %php5_version-%php5_release
Provides: php5-ctype = %php5_version-%php5_release
Provides: php5-date = %php5_version-%php5_release
Provides: php5-filter = %php5_version-%php5_release
Provides: php5-ftp = %php5_version-%php5_release
Provides: php5-gettext = %php5_version-%php5_release
Provides: php5-hash = %php5_version-%php5_release
Provides: php5-iconv = %php5_version-%php5_release
Provides: php5-json = %php5_version-%php5_release
Provides: php5-libxml = %php5_version-%php5_release
Provides: php5-mhash = %php5_version-%php5_release
Provides: php5-pcre = %php5_version-%php5_release
Provides: php5-posix = %php5_version-%php5_release
Provides: php5-reflection = %php5_version-%php5_release
Provides: php5-session = %php5_version-%php5_release
Provides: php5-shmop = %php5_version-%php5_release
Provides: php5-simplexml = %php5_version-%php5_release
Provides: php5-spl = %php5_version-%php5_release
Provides: php5-standard = %php5_version-%php5_release
Provides: php5-sysvmsg = %php5_version-%php5_release
Provides: php5-sysvsem = %php5_version-%php5_release
Provides: php5-sysvshm = %php5_version-%php5_release
Provides: php5-tokenizer = %php5_version-%php5_release
Provides: php5-wddx = %php5_version-%php5_release
Provides: php5-xml = %php5_version-%php5_release
Provides: php5-xmlwriter = %php5_version-%php5_release
Provides: php5-zlib = %php5_version-%php5_release
Provides: php5-libs = %php5_version-%release


Obsoletes: php5-simplexml php5-mhash

%description libs
The php5-libs package contains parts of PHP5 distribution which are
in use by other PHP5-related packages.

%prep
%setup -q -n php5-source
%setup -q -n php5-source -T -D -a4
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch5 -p1
%patch6 -p1
%patch9 -p1 -b .scandir
%patch12 -p2 -b .alternatives
%patch13 -p1
%patch17 -p1
%patch20 -p1
%patch30 -p0
%patch32 -p1
%patch33 -p2
%patch34 -p2
%patch38 -p2
%patch39 -p2
%patch40 -p1
%patch41 -p2
%patch51 -p2
pushd Zend
%patch60 -p1
popd
%patch61 -p1
%patch62 -p1
%patch63 -p1
%patch64 -p1
%patch65 -p1
%patch66 -p1


cp Zend/LICENSE Zend/ZEND_LICENSE
cp Zend/ZEND_CHANGES Zend/ZEND_ChangeLog 
mv README.SELF-CONTAINED-EXTENSIONS SELF-CONTAINED-EXTENSIONS

cp -dpR %SOURCE2 .

LIBS="$LIBS -lpthread"
CFLAGS="%optflags -fPIC"
export LIBS CFLAGS

subst "s,./vcsclean,," build/buildcheck.sh
subst "s,./stamp=$,," build/buildcheck.sh


%autoreconf -I build
./buildconf --force

%build
%php5_env

%configure \
	--prefix=%_prefix \
	--program-suffix=5 \
	--localstatedir=%_var \
	--enable-inline-optimization \
	--with-config-file-path=%php5_sysconfdir/ \
	--with-config-file-scan-dir=%php5_sysconfdir/%php5_sapi/php.d/ \
	--with-pic \
	\
	--enable-cli \
	--disable-cgi \
	\
	--disable-debug \
	--enable-safe-mode \
	--disable-magic-quotes \
	--disable-rpath \
	\
	--enable-bcmath \
	--enable-ctype \
	--enable-ftp \
	--enable-session \
	--enable-shmop \
	--enable-sysvsem \
	--enable-sysvshm \
	--enable-sysvmsg \
	--enable-libxml \
	--disable-dom \
	--disable-opcache \
	--enable-simplexml \
	--disable-pdo \
	--enable-hash \
	--enable-xml \
	--enable-wddx \
	--disable-fileinfo \
	--disable-xmlreader \
	--enable-shared=yes \
	--enable-static=no \
	\
	--with-layout=GNU \
	--with-exec-dir=%_bindir \
	--with-zlib=%_usr \
	--with-gettext=%_usr \
	--with-iconv \
	--enable-mysqlnd=shared \
	--without-mysql \
	--with-mm=%_usr \
	--without-sqlite \
%ifarch %e2k
	--without-pcre-jit \
%endif
	--with-regex=php \
	--without-pear \
	--with-system-tzdata \
#
export NPROCS=1
%php5_make

%install
# XXX see https://bugzilla.altlinux.org/show_bug.cgi?id=14726
%add_findreq_skiplist %php5_libdir/build/config.guess
%php5_make_install

# All things already installed, install differences only
mkdir -p \
	%buildroot/%php5_libdir/extensions \
	%buildroot/%_bindir \
	%buildroot/%php5_sysconfdir/%php5_sapi/php.d \
	%buildroot/%php5_extconf \
	%buildroot/%php5_servicedir/%php5_sapi \
	%buildroot/%_datadir/php/%_php5_version/modules

install -m 644 %SOURCE3                      %buildroot/%php5_sysconfdir/%php5_sapi/php.ini

for f in \
  %buildroot/%php5_sysconfdir/%php5_sapi/php.ini
do
  subst 's,@PHP_MAJOR@,%_php5_major,g' "$f"
  subst 's,@PHP_VERSION@,%_php5_version,g' "$f"
  subst 's,@PHP_LIBDIR@,%_libdir/php,g' "$f"
  subst 's,@SAPI@,%php5_sapi,g' "$f"
done

[ -f "%buildroot/%_bindir/phpextdist" ] || 
    cp -dpR scripts/dev/phpextdist %buildroot/%_bindir/

chmod 755 %buildroot/%_bindir/*

# This file is not needed by any program.
rm -f %buildroot/%_libdir/libphp-%_php5_version.la

# Remove RPATH
/usr/bin/chrpath --delete %buildroot/%_bindir/php5-%_php5_version

# Make alternatives support.
install -d %buildroot/%_altdir
php_weight="$(printf %%s "%_php5_version" | sed 's,[^[:digit:]],,g')"

cat << EOF > %buildroot/%_altdir/php5
%_bindir/phar           %_bindir/phar5.phar     $php_weight
%_bindir/phpdbg         %_bindir/phpdbg5        $php_weight
%_bindir/php5   %_bindir/php5-%_php5_version    $php_weight
%_bindir/php	%_bindir/php5-%_php5_version	$php_weight
%_man1dir/php.1	%_man1dir/php5-%_php5_version.1	$php_weight
EOF

cat << EOF > %buildroot/%_altdir/php5-devel
%_bindir/phpize		%_bindir/phpize5	$php_weight
%_bindir/php-config	%_bindir/php-config5	$php_weight
%_man1dir/php-config.1	%_man1dir/php-config5.1	$php_weight
EOF

# Make backup some files to make devel package.
%make clean

find scripts/apache/ -type f | xargs chmod 644
mkdir -p sapi/apache/apache/
cp -dpR scripts/apache/* sapi/apache/apache/

mkdir -p %buildroot%_usrsrc/php5-devel/{ext,sapi,conf}
cp -dpR php.ini* %buildroot%_usrsrc/php5-devel/conf
cp -dpR ext/*    %buildroot%_usrsrc/php5-devel/ext
cp -dpR sapi/*   %buildroot%_usrsrc/php5-devel/sapi

# Add necessary files to build any sapi packages.
mkdir -p %buildroot%_usrsrc/php5-devel/sapi/BUILD
cp -dpR main/internal_functions.c %buildroot%_usrsrc/php5-devel/sapi/BUILD
cp -dpR include                   %buildroot%_usrsrc/php5-devel/sapi/BUILD

# install headers for PDO subpackages
install -m644 -D ext/pdo/php_pdo.h %buildroot%_includedir/php/%_php5_version/ext/pdo/php_pdo.h
install -m644 -D ext/pdo/php_pdo_driver.h %buildroot%_includedir/php/%_php5_version/ext/pdo/php_pdo_driver.h
install -m644 -D ext/pdo/php_pdo_error.h %buildroot%_includedir/php/%_php5_version/ext/pdo/php_pdo_error.h

# install headers for mysqlnd subpackages
install -m644 -D ext/mysqlnd/mysqlnd.h %buildroot%_includedir/php/%_php5_version/ext/mysqlnd/mysqlnd.h
install -m644 -D ext/mysqlnd/mysqlnd_portability.h %buildroot%_includedir/php/%_php5_version/ext/mysqlnd/mysqlnd_portability.h
install -m644 -D ext/mysqlnd/mysqlnd_enum_n_def.h %buildroot%_includedir/php/%_php5_version/ext/mysqlnd/mysqlnd_enum_n_def.h
install -m644 -D ext/mysqlnd/mysqlnd_structs.h %buildroot%_includedir/php/%_php5_version/ext/mysqlnd/mysqlnd_structs.h

mkdir -p %buildroot/%php5_extconf/mysqlnd
echo "file_ini=01_mysqlnd.ini" >%buildroot/%php5_extconf/mysqlnd/params
echo "extension=mysqlnd.so" >%buildroot/%php5_extconf/mysqlnd/config

# clean rpath in phpinfo
chrpath -d %buildroot%_bindir/phpinfo5-%_php5_version

# install correct phar
mv %buildroot%_bindir/phar.phar %buildroot%_bindir/phar5.phar
ln -sf phar5.phar %buildroot%_bindir/phar5
sed -i -s 's,%buildroot,,' %buildroot%_bindir/phar5.phar

# rpm macros 
mkdir -p %buildroot/%_sysconfdir/rpm/macros.d
cp %SOURCE1 %buildroot/%_sysconfdir/rpm/macros.d/%php5_name-ver


subst 's,@php5_name@,%php5_name,'           %buildroot/%_sysconfdir/rpm/macros.d/%php5_name-ver
subst 's,@_php5_version@,%_php5_version,'   %buildroot/%_sysconfdir/rpm/macros.d/%php5_name-ver
subst 's,@php5_major@,%_php5_major,'   %buildroot/%_sysconfdir/rpm/macros.d/%php5_name-ver
subst 's,@_php5_snapshot@,%_php5_snapshot,' %buildroot/%_sysconfdir/rpm/macros.d/%php5_name-ver
subst 's,@php5_release@,%php5_release,'     %buildroot/%_sysconfdir/rpm/macros.d/%php5_name-ver


%post
%force_update_alternatives
%php5_sapi_postin

%preun
%php5_sapi_preun

%define		php5_extension	mysqlnd

%post mysqlnd
%php5_extension_postin

%preun mysqlnd
%php5_extension_preun

%files
%_altdir/php5
%_bindir/php5-%_php5_version
%_bindir/phar5*
%_bindir/phpinfo5-%_php5_version
%dir %php5_sysconfdir/%php5_sapi
%php5_sysconfdir/%php5_sapi/*
%config(noreplace) %php5_sysconfdir/%php5_sapi/php.ini
%_man1dir/php5-%_php5_version.1*
%_man1dir/php5.1*
%_man1dir/phar5*.1*
%php5_servicedir/cli
%doc CODING_STANDARDS CREDITS INSTALL LICENSE
%doc NEWS README.* Zend/ZEND_* php.ini-* EXTENSIONS
%doc UPGRADING*

%files -n rpm-build-php-version
%_sysconfdir/rpm/macros.d/%php5_name-ver

%files libs
%dir %php5_sysconfdir
%php5_libdir
%php5_datadir
%exclude %php5_extdir/mysqlnd*
%exclude %php5_extconf/mysqlnd
%_libdir/libphp-%_php5_version.so*
%exclude %php5_libdir/build
%exclude %php5_servicedir/cli

%files mysqlnd
%php5_extdir/mysqlnd*
%php5_extconf/mysqlnd/*

%files devel
%_altdir/php5-devel
%_bindir/php-config5
%_bindir/phpize5
%_bindir/phpextdist
%_includedir/php
%php5_libdir/build
%_libdir/libphp-%_php5_version.a
%_usrsrc/php5-devel
%_man1dir/php-config5.1*
%_man1dir/phpize5.1*
%doc SELF-CONTAINED-EXTENSIONS php-packaging.readme
%doc tests run-tests.php 

%changelog
