%define		php5_extension	facedetect
%define 	real_name	facedetect
%define		real_version	1.1

Name:	 	php5-%{php5_extension}
Version:	%php5_version
Release:	%php5_release

Summary:	PHP5 extension to detect faces on images

License:	PHP License
Group:		System/Servers
URL:		http://www.xarg.org/project/php-facedetect/

Packager:	Nikolay A. Fetisov <naf@altlinux.ru>

# git://github.com/infusion/PHP-Facedetect.git
Source0:	%real_name-%real_version.tar
Source1:	php-%php5_extension.ini
Source2:	php-%php5_extension-params.sh
Patch0:		%real_name-%real_version-alt-fix_libs.patch
Patch1:		php5-facedetect-5.6.33-opencv3.patch

BuildRequires(pre): rpm-build-php5
BuildRequires: php5-devel = %php5_version
BuildRequires: libopencv-devel

%description
Facedetect extension provides a PHP implementation of the OpenCV
library. The extension offers two functions, the first one returns
the number of faces found on the given image and the other an 
associative array of their coordinates. 

%prep
%setup -T -c
tar xvf %SOURCE0
%patch0 -p1
%patch1 -p1

%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version
%configure \
	--with-%php5_extension \
	--with-libdir=%_lib \
	#

/bin/ln -s -- config.h cvconfig.h
%php5_make

%install
%php5_make_install
install -D -m 644 -- %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 -- %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%doc CREDITS

%php5_extconf/%php5_extension
%php5_extdir/*

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
