%define php5_extension	imap

Name: php5-imap
Version: %php5_version
Release: %php5_release.2

Summary: IMAP module for PHP5
Group: System/Servers
License: PHP Licence

Source1: php-%php5_extension.ini
Source2: php-%php5_extension-params.sh

Patch: php-imap.patch

BuildRequires(pre): rpm-build-php5
BuildRequires: php5-devel = %php5_version

# Automatically added by buildreq on Fri Jul 01 2005
BuildRequires: libpam-devel libssl-devel pkgconfig uw-imap-devel

%description
The %name package contains a dynamic shared object (DSO) for PHP. The
%name module adds IMAP (Internet Message Access Protocol) support to
PHP. IMAP is a protocol for retrieving and uploading e-mail messages on
mail servers. PHP is an HTML-embedded scripting language for use with
Apache.  If you need IMAP support for PHP applications, you will need to
install this package and PHP.

%prep
%setup -T -c
cp -pr %php5_extsrcdir/%php5_extension/* .
%patch -p1

%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version
%configure \
	PHP_OPENSSL=no \
	--with-kerberos=no \
	--with-imap-ssl=yes \
	--with-libdir=%_lib \
	--with-%php5_extension=%_usr
%php5_make

%install
%php5_make_install
install -D -m 644 %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%php5_extconf/%php5_extension
%php5_extdir/*
%doc CREDITS

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
