%define php5_extension	ldap

Name: php5-%php5_extension
Version: %php5_version
Release: %php5_release

Summary: LDAP module for PHP5
Group: System/Servers
License: PHP Licence

Packager: Vladimir V Kamarzin <vvk@altlinux.ru>
Source1: php-%php5_extension.ini
Source2: php-%php5_extension-params.sh

BuildRequires(pre): rpm-build-php5
BuildRequires: php5-devel = %php5_version
#BuildRequires: php5-devel = %php5_version-alt2

BuildRequires: libldap-devel libsasl2-devel

Requires: php5-libs = %php5_version

%description
The %name includes a dynamic shared object (DSO) that adds
Lightweight Directory Access Protocol (LDAP) support to PHP. LDAP is a
set of protocols for accessing directory services over the Internet.
PHP is an HTML-embedded scripting language. If you need LDAP support
for PHP applications, you will need to install this package in addition
to the php package.

%prep
%setup -T -c
cp -pr %php5_extsrcdir/%php5_extension/* .

%build

phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDLIBS=-lphp-%_php5_version
%configure \
	--with-%php5_extension=%_usr \
	--with-ldap-sasl=%prefix \
	--with-libdir=$(echo "%_libdir" | cut -d '/' -f3)
%php5_make

%install
%php5_make_install
install -D -m 644 %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%php5_extconf/%php5_extension
%php5_extdir/*
%doc CREDITS

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
