%define		php5_extension	xsl

Name:	 	php5-%php5_extension
Version:	%php5_version
Release:	%php5_release

Summary:	Sablotron XSLT support for PHP5
Group:		System/Servers
License:	PHP Licence

Prereq:		php5-dom

Source1:	php-%php5_extension.ini
Source2:	php-%php5_extension-params.sh

Patch: php-xsl-dom.patch

BuildRequires(pre): rpm-build-php5
BuildRequires:	php5-devel = %php5_version

# Automatically added by buildreq on Fri Jul 01 2005
BuildRequires: libxml2-devel libxslt-devel zlib-devel

%description
The %name includes a dynamic shared object (DSO) that adds
XSLT support to PHP. Sablotron is a fast, compact and portable XSLT processor.
If you need XSLT support for PHP applications, you will need
to install this package in addition to the php package.

%prep
%setup -T -c
cp -pr %php5_extsrcdir/%php5_extension/* .
mkdir -p ./ext
cp -pr %php5_extsrcdir/dom ./ext/
%patch -p1

%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version
%configure \
	PHP_DOM=yes \
	PHP_LIBXML_SHARED=yes \
	--with-%php5_extension=%_usr
%php5_make

%install
%php5_make_install
install -D -m 644 %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%php5_extconf/%php5_extension
%php5_extdir/*
%doc CREDITS

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
