%define pIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define pIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define pIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define pIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%def_disable libcap
%def_enable qt5
%def_disable tqt
%def_disable fltk

Name: pinentry
Version: 1.1.0
Release: alt1%ubt

Group: File tools
Summary: Simple PIN or passphrase entry dialog
Url: http://gnupg.org/related_software/pinentry/
License: GPLv2+

Requires: %name-common = %version-%release

Requires: %name-qt4 = %version-%release
Requires: %name-gtk2 = %version-%release

# ftp://ftp.gnupg.org/gcrypt/pinentry/%name-%version.tar.gz
Source: %name-%version.tar
Source1: pinentry-wrapper
# ALT
Patch10: alt-mask-xprop.patch


BuildRequires(pre): rpm-build-ubt
%if_enabled qt5
BuildRequires(pre): qt5-base-devel
%endif
%if_enabled tqt
BuildRequires: libtqt3-devel
%endif
%if_enabled libfltk-devel
BuildRequires: libfltk-devel
%endif
BuildRequires(pre): libqt4-devel
%if_enabled libcap
BuildRequires: libcap-devel
%endif
BuildRequires: gcc-c++ libgtk+2-devel libncursesw-devel
BuildRequires: libsecret-devel gcr-libs-devel libassuan-devel
BuildRequires: texinfo

%description
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.

%package common
Group: %group
Summary: %summary
Provides: %name = %version-%release
Provides: %name-terminal = %version-%release
Provides: %name-console = %version-%release
Provides: %name-tty = %EVR
Provides: %name-curses = %EVR
Obsoletes: %name-curses < %EVR
Conflicts: pinentry < 0.7.2 pinentry-curses < 0.7.2
Conflicts: pinentry-qt < 0.7.2 pinentry-gtk < 0.7.2

%package gtk2
Group: %group
Summary: %summary
Requires: %name-common = %EVR
Requires: xprop
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release
Provides: pinentry-gtk = %EVR
Obsoletes: pinentry-gtk < %EVR

%package gnome3
Group: %group
Summary: %summary
Requires: %name-common = %EVR
Requires: xprop
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release

%package qt5
Group: %group
Summary: %summary
Requires: xprop
Requires: %name-common = %EVR
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release
Provides: pinentry-qt = %EVR
Obsoletes: pinentry-qt < %EVR

%package qt4
Group: %group
Summary: %summary
Requires: xprop
Requires: %name-common = %EVR
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release

%description gtk2
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.
%description gnome3
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.
%description qt5
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.
%description qt4
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.
%description common
This package contains common files and documentation for %name.

%prep
%setup -T -c
tar xf %SOURCE0
mv %name-%version gui

cp -ar gui gui-qt5
cp -ar gui tui
mv gui gui-qt4

install -m0644 %SOURCE1 pinentry-wrapper
%patch10 -p0

for d in gui-qt5 gui-qt4 tui ; do
    pushd $d
    %autoreconf
    popd
done

%build
%add_optflags -std=gnu++11

pushd gui-qt5
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --enable-pinentry-gtk2 \
    %{?_enable_tqt:--enable-pinentry-tqt} \
    %{?_enable_fltk:--enable-pinentry-fltk} \
    --enable-pinentry-gnome3 \
    --enable-pinentry-qt \
    --enable-pinentry-qt5 \
    --enable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd

pushd gui-qt4
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-tqt \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --enable-pinentry-qt \
    --disable-pinentry-qt5 \
    --enable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd

pushd tui
%configure \
    --disable-rpath \
    --enable-pinentry-curses \
    --enable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-tqt \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --disable-pinentry-qt \
    --disable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd

%install
pushd gui-qt5
%makeinstall_std
popd
mv %buildroot/%_bindir/%name-qt %buildroot/%_bindir/%name-qt5
pushd gui-qt4
%makeinstall_std
popd
mv %buildroot/%_bindir/%name-qt %buildroot/%_bindir/%name-qt4
pushd tui
%makeinstall_std
popd
rm %buildroot%_bindir/%name

ln -s %name-gtk-2 %buildroot/%_bindir/%name-gtk
ln -s %name-qt5 %buildroot/%_bindir/%name-qt

install -p -m0755 -D pinentry-wrapper %buildroot/%_bindir/pinentry

%files gtk2
%_bindir/%name-gtk
%_bindir/%name-gtk-2

%files qt4
%_bindir/%name-qt4

%files qt5
%_bindir/%name-qt5
%_bindir/%name-qt

%files gnome3
%_bindir/%name-gnome3

%files common
%doc gui-qt5/AUTHORS gui-qt5/NEWS gui-qt5/README gui-qt5/THANKS
%_bindir/%name
%_bindir/%name-curses
%_bindir/%name-tty
%_infodir/*.info*

%changelog
