%def_disable snapshot

%define ver_major 0.98
%define api_ver 1.0
%define gst_api_ver 1.0

%define gst_ver 1.10.2
%define gtk_ver 3.20
%define gi_ver 1.32

Name: pitivi
Version: %ver_major.1
Release: alt0.M80P.1

Summary: PiTiVi allows users to easily edit audio/video projects
License: LGPLv2.1+
Group: Video
Url: http://www.pitivi.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Conflicts: gst-transcoder
Obsoletes: gst-transcoder
Provides: gst-transcoder

# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_path %_libdir/%name/python

# should be provided by python3-module-gst1.0
%add_python3_req_skip gi.repository.GstPbutils

Requires: python3-module-gst%gst_api_ver >= %gst_ver
Requires: gstreamer-editing-services
Requires: gst-validate
Requires: gst-libav >= %gst_ver
Requires: gst-plugins-base%gst_api_ver >= %gst_ver
Requires: gst-plugins-good%gst_api_ver >= %gst_ver
Requires: gst-plugins-bad%gst_api_ver >= %gst_ver
Requires: gst-plugins-ugly%gst_api_ver >= %gst_ver
Requires: python3-module-canberra

BuildRequires: git meson python3-module-nose2
BuildRequires: intltool yelp-tools rpm-build-gir libappstream-glib-devel libcairo-devel
BuildRequires: rpm-build-python3 python3-devel python3-module-pygobject3-devel
BuildRequires: python3-module-pycairo-devel
BuildRequires: gst-plugins%gst_api_ver-devel
BuildRequires: libgtk+3-devel >= %gtk_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libgstreamer%gst_api_ver-gir-devel gst-plugins%gst_api_ver-gir-devel
BuildRequires: gst-validate libgtk+3-gir-devel

%description
Pitivi is a video editor built upon the GStreamer Editing Services.
It aims to be an intuitive and flexible application that can appeal to
newbies and professionals alike.

%prep
%setup
##subst 's/\(nosetests\)/\13/' tests/meson.build

%build
# python script since 0.97
./configure --prefix=/usr \
	--libdir=%_lib

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_datadir/%name/
#%_datadir/mime/packages/%name.xml
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*
#%_man1dir/%name.1*
%_datadir/appdata/%name.appdata.xml

#gst-transcoder-1.12.0 ?!
%_bindir/gst-transcoder-%api_ver
%_libdir/libgsttranscoder-%api_ver.so.0
%_typelibdir/GstTranscoder-%api_ver.typelib
%_libdir/gstreamer-%api_ver/libgsttranscode.so
%doc AUTHORS NEWS RELEASE

# devel
%exclude %_libdir/libgsttranscoder-%api_ver.so
%exclude %_pkgconfigdir/gst-transcoder-%api_ver.pc
%exclude %_includedir/gstreamer-%api_ver/gst/transcoder/
%exclude %_girdir/GstTranscoder-%api_ver.gir

%changelog
