%ifarch %ix86 x86_64 armh mips64el
%def_enable rutokenecp
%else
%def_disable rutokenecp
%endif

%ifarch %ix86 x86_64 armh aarch64 e2k
%def_enable isbc
%else
%def_disable isbc
%endif

# libjcpkcs11 is not available in Sisyphus any more!
%def_disable jacarta

Name: pkcs11-profiles
Version: 0.1.9
Release: alt0.M80P.2

Summary: Set of scripts and profiles for PAM PKCS11 configuration
License: GPLv3+
Group: System/Configuration/Other

Conflicts: pam_pkcs11 < 0.6.9-alt30

Source0: %name-%version.tar

%description
%summary

%package common
Summary: Control scripts for profile-based PAM PKCS11 configuration
License: GPLv3+
Group: System/Configuration/Other
BuildArch: noarch

%description common
Control scripts for profile-based PAM PKCS11 configuration.

%package rutokenecp
Summary: RuToken ECP PAM PKCS11 module configuration
License: GPLv3+
Group: System/Configuration/Other
Requires: %name-common = %version-%release
Requires: pam_pkcs11 >= 0.6.9-alt9
Requires: librtpkcs11ecp >= 1.5.3.0-alt4

%description rutokenecp
RuToken ECP PAM PKCS11 module configuration

%package isbc
Summary: ESMART PAM PKCS11 module configuration
License: GPLv3+
Group: System/Configuration/Other
Requires: %name-common = %version-%release
Requires: pam_pkcs11 >= 0.6.9-alt9
Requires: pam_pkcs11-isbc
Requires: isbc-pkcs11

%description isbc
ESMART PAM PKCS11 module configuration

%package jacarta
Summary: JaCarta PAM PKCS11 module configuration
License: GPLv3+
Group: System/Configuration/Other
Requires: %name-common = %version-%release
Requires: pam_pkcs11 >= 0.6.9-alt9
Requires: libjcpkcs11

%description jacarta
JaCarta PAM PKCS11 module configuration

%package p11-kit-proxy
Summary: PKCS#11 Kit Proxy module configuration
License: GPLv3+
Group: System/Configuration/Other
Requires: %name-common = %version-%release
Requires: pam_pkcs11 >= 0.6.9-alt17
Requires: libp11-kit >= 0.23.8

%description p11-kit-proxy
PKCS#11 Kit Proxy module configuration

%package zastava
Summary: "Zastava" PAM PKCS#11 profile and configuration files
License: GPLv3+
Group: System/Configuration/Other
Requires: %name-common = %version-%release
Requires: pam_pkcs11 >= 0.6.9-alt18
Requires: %name-messages-zastava = %version-%release
BuildArch: noarch

%description zastava
Contains profile and configuration files used for "Zastava" installation

%package messages-zastava
Summary: "Zastava" PAM PKCS#11 message set
License: GPLv3+
Group: System/Configuration/Other
Requires: %name-common = %version-%release
Requires: pam_pkcs11 >= 0.6.9-alt18
BuildArch: noarch

%description messages-zastava
Contains prompts and other messages of "Zastava" PAM PKCS#11 set

%prep
%setup

%build
%autoreconf
%configure syslibdir=/%_lib
%make_build syslibdir=/%_lib

%install
%makeinstall_std 

%define confdir %_sysconfdir/security/pam_pkcs11

%files common
%_controldir/*
%dir %confdir/profiles
%config(noreplace) %confdir/profiles/opensc
%dir %confdir/modules.avail
%config(noreplace) %confdir/modules.avail/aladdin
%dir %confdir/mapping.profiles
%config(noreplace) %confdir/mapping.profiles/cert
%config(noreplace) %confdir/mapping.profiles/cn
%config(noreplace) %confdir/mapping.profiles/mail
%config(noreplace) %confdir/mapping.profiles/snils
%config(noreplace) %confdir/mapping.profiles/snils_scrambled
%config(noreplace) %confdir/mapping.profiles/subject
%dir %confdir/message.profiles
%config(noreplace) %confdir/message.profiles/default
%dir %confdir/param-set.d
%config(noreplace) %confdir/param-set.d/default

%if_enabled rutokenecp
%files rutokenecp
%config(noreplace) %confdir/modules.avail/rutokenecp
%config(noreplace) %confdir/profiles/rutokenecp
%endif

%files p11-kit-proxy
%config(noreplace) %confdir/modules.avail/p11_kit_proxy
%config(noreplace) %confdir/profiles/p11_kit_proxy

%if_enabled isbc
%files isbc
%config(noreplace) %confdir/modules.avail/isbc
%config(noreplace) %confdir/profiles/isbc
%endif

%if_enabled jacarta
%files jacarta
%config(noreplace) %confdir/modules.avail/jacarta
%config(noreplace) %confdir/profiles/jacarta
%endif

%files zastava
%config(noreplace) %confdir/param-set.d/zastava
%config(noreplace) %confdir/zastava_*

%files messages-zastava
%config(noreplace) %confdir/message.profiles/zastava

%changelog
