Name: pkg-config
Version: 0.25
Release: alt2

Summary: Pkgconfig helps make building packages easier
License: GPLv2+
Group: Development/Other
Url: http://pkg-config.freedesktop.org/wiki/
Packager: Dmitry V. Levin <ldv@altlinux.org>

Provides: %_libdir/pkgconfig
Provides: %_datadir/pkgconfig

Provides: pkgconfig-reqprov, pkgconfig-recursion
Provides: pkgconfig-print-requires-private, pkgconfig = 1:%version-%release
Obsoletes: pkgconfig

# due to pkg.c:add_virtual_pkgconfig_package
Provides: pkgconfig(pkg-config) = %version

# http://git.altlinux.org/gears/p/pkg-config.git
Source: %name-%version-%release.tar

BuildRequires: glib2-devel libpopt-devel

%define docdir %_docdir/%name-%version

%description
The pkg-config program is used to retrieve information about installed
libraries in the system.  It is typically used to compile and link
against one or more libraries.

%prep
%setup -n %name-%version-%release
sed -i 's/^\([A-Z]*_SUBDIR *=\).*/\1/' Makefile.am

%build
%autoreconf
%configure --docdir=%docdir --with-installed-glib --with-installed-popt
%make_build

%install
%makeinstall_std
install -dm755 %buildroot{%_datadir,%_libdir}/pkgconfig
install -pm644 AUTHORS NEWS README %buildroot%docdir/

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<\EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
# %name buildreq filter.
^(%_libdir|%_datadir)/pkgconfig/[^/]+\.pc$
EOF

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/%name-files.req.list
# %name dirlist for %_rpmlibdir/files.req
/usr/lib/pkgconfig	%name
/usr/lib64/pkgconfig	%name
/usr/share/pkgconfig	%name
EOF

%check
%make_build -k check

%files
%config %_sysconfdir/buildreqs/files/ignore.d/*
%config %_rpmlibdir/*
%_bindir/pkg-config
%dir %_libdir/pkgconfig
%dir %_datadir/pkgconfig
%_datadir/aclocal/*
%_man1dir/*
%docdir/

%changelog
