Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ unzip saxon
# END SourceDeps(oneline)
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
Name:           pmd
Epoch:          0
Version:        5.4.1
Release:        alt1_1jpp8
Summary:        Scans Java source code and looks for potential problems
License:        BSD and ASL 2.0 and LGPLv3+
URL:            http://pmd.sourceforge.net/
BuildArch:      noarch

Source0:        http://downloads.sourceforge.net/project/pmd/pmd/%{version}/pmd-src-%{version}.zip

# fix api incompatibilities with newer saxon
# not sent upstream
Patch1:         saxon.patch

BuildRequires:  maven-local
BuildRequires:  mvn(com.beust:jcommander)
BuildRequires:  mvn(commons-io:commons-io)
BuildRequires:  mvn(jaxen:jaxen)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(net.java.dev.javacc:javacc)
BuildRequires:  mvn(net.sf.saxon:saxon)
BuildRequires:  mvn(net.sourceforge.pmd:pmd-build)
BuildRequires:  mvn(org.apache.ant:ant)
BuildRequires:  mvn(org.apache.ant:ant-testutil)
BuildRequires:  mvn(org.apache.commons:commons-lang3)
BuildRequires:  mvn(org.apache.maven.doxia:doxia-module-markdown)
BuildRequires:  mvn(org.apache.maven.plugins:maven-antrun-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-assembly-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-site-plugin)
BuildRequires:  mvn(org.codehaus.mojo:build-helper-maven-plugin)
BuildRequires:  mvn(org.jacoco:jacoco-maven-plugin)
BuildRequires:  mvn(org.mozilla:rhino)
BuildRequires:  mvn(org.ow2.asm:asm)
BuildRequires:  mvn(org.sonatype.oss:oss-parent:pom:)
Source44: import.info

%description
PMD scans Java source code and looks for potential problems like:
* Possible bugs: empty try/catch/finally/switch statements
+ Dead code: unused local variables, parameters and private methods
+ Suboptimal code: wasteful String/StringBuffer usage
+ Overcomplicated expressions: unnecessary if statements, for loops
  that could be while loops
+ Duplicate code: copied/pasted code means copied/pasted bugs

PMD has plugins for JDeveloper, Eclipse, JEdit, JBuilder, BlueJ,
CodeGuide, NetBeans/Sun Java Studio Enterprise/Creator, IntelliJ IDEA,
TextPad, Maven, Ant, Gel, JCreator, and Emacs.

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
API documentation for %{name}.

%prep
%setup -q -n %{name}-src-%{version}
%patch1 -p1

# remove all binary libs
find . -name "*.jar" -exec rm -f {} \;
find . -name "*.class" -exec rm -f {} \;

%mvn_alias : pmd:pmd

%pom_xpath_remove pom:build/pom:extensions

%pom_xpath_set pom:parent/pom:version %{version} */pom.xml

sed -i 's/net.sourceforge.saxon/net.sf.saxon/' `find -name pom.xml`

%pom_xpath_set -r '//pom:property[@name="javacc.jar"]/@value' `xmvn-resolve net.java.dev.javacc:javacc`

%build
# tests require com.github.tomakehurst:wiremock
%mvn_build -f -- -P!jdk9-disabled

%install
%mvn_install

%files -f .mfiles
%doc LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc LICENSE NOTICE

%changelog
