
%define _libexecdir %prefix/libexec

Summary: SELinux policy core utilities
Name: policycoreutils
Epoch:   1
Version: 2.5
Release: alt1
License: GPLv2
Group: System/Base
Url: http://userspace.selinuxproject.org
Source0: %name-%version.tar
Source1: restorecond.init
Source2: sandbox.init
Source3: system-config-selinux.pam
Source4: system-config-selinux.png
Source5: system-config-selinux.desktop
Source6: system-config-selinux.console
Source7: selinux-polgengui.desktop
Source8: selinux-polgengui.console
Source9: mcstrans.init
Source11: restorecond.service
Source12: mcstransd.service
Patch1: alt-autorelabel-fix-path.patch
Patch2: alt-fix-free-groups.patch
Patch3: alt-mcstrans.patch
Patch4: alt-cap-setgid.patch
Patch5: alt-symlink.patch
Patch6: alt-semodule-path.patch
Patch7: alt-newrole.patch
Patch8: alt-fix-compile.patch

%define mcstrans_ver 0.3.3
Requires: python-module-semanage python-module-audit

BuildPreReq: rpm-build-xdg
BuildRequires: libaudit-devel libcap-devel libpam-devel
BuildRequires: libselinux-devel libsemanage-devel libsepol-devel libsepol-devel-static
BuildRequires: python-devel
BuildRequires: python-module-pygnome
BuildRequires: desktop-file-utils
BuildRequires: python-module-sepolgen
BuildRequires: glib2-devel libdbus-glib-devel
BuildRequires: libcap-ng-devel libpcre-devel libcgroup-devel

# Build sequence: libsepol -> setools -> policycoreutils
BuildRequires: libsetools-devel >= 3.3.8-alt3

%description
policycoreutils contains the policy core utilities that are required
for basic operation of a SELinux system.  These utilities include
load_policy to load policies, setfiles to label filesystems, newrole
to switch roles, and run_init to run /etc/init.d scripts in the proper
context.


%package newrole
Summary: The newrole application for RBAC/MLS
Group: System/Base
Requires: %name = %version-%release

%description newrole
RBAC/MLS policy machines require newrole as a way of changing the role
or level of a logged in user.


%package sandbox
Summary: SELinux sandbox utilities
Group: System/Base
Requires: %name = %version-%release

%description sandbox
This package contains the sandbox which allow you to run an applications
within a tightly confined SELinux domain.


%package sandbox-x
Summary: SELinux sandbox utilities for X applications
Group: System/Base
Requires: %name-sandbox = %version-%release
Requires: xorg-xephyr
Requires: matchbox-window-manager
Requires: xmodmap
BuildArch: noarch

%description sandbox-x
This package contains the scripts to create graphical sandboxes.


%package restorecond
Summary: SELinux restorecond utilities
Group:   System/Base
Obsoletes: mcstrans <= 0.3.1
Provides: mcstrans = %mcstrans_ver

%description restorecond
This package contains the restorecond service.


%package mcstransd
Summary: SELinux Translation Daemon
Group: System/Base

%description mcstransd
mcstrans provides an translation daemon to translate SELinux categories
from internal representations to user defined representation.


%package devel
Requires: %name = %version-%release
Summary: SELinux policy core policy devel utilities
Group: System/Base

%description devel
The policycoreutils-devel package contains the management tools use to
develop policy in an SELinux environment.


%package gui
Summary: SELinux configuration GUI
Group: System/Base
Requires: policycoreutils = %version-%release
#Requires: setools-console
Requires: selinux-policy

%description gui
system-config-selinux is a utility for managing the SELinux environment.


%prep
%setup
%patch1 -p1
%patch2 -p2
%patch3 -p2
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
sed -i '/^override CFLAGS/s/ -Werror//g' sandbox/Makefile
sed -i 's/\( awk \)-S /\1/g' setfiles/Makefile


%build
%make_build LSPP_PRIV=y LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C mcstrans LIBDIR=%_libdir CFLAGS="%optflags $(pkg-config --cflags-only-I libpcre)"


%install
install -d -m 0755 %buildroot/var/lib/selinux
install -D -m 0644 %SOURCE3 %buildroot%_sysconfdir/pam.d/system-config-selinux
install -D -m 0644 %SOURCE3 %buildroot%_sysconfdir/pam.d/selinux-polgengui
install -D -m 0644 %SOURCE4 %buildroot%_iconsdir/hicolor/24x24/apps/system-config-selinux.png
install -D -m 0644 %SOURCE4 %buildroot%_datadir/system-config-selinux/system-config-selinux.png
install -D -m 0644 %SOURCE6 %buildroot%_sysconfdir/security/console.apps/system-config-selinux
install -D -m 0644 %SOURCE8 %buildroot%_sysconfdir/security/console.apps/selinux-polgengui

%makeinstall_std LSPP_PRIV=y LIBDIR=%buildroot%_libdir
%makeinstall_std -C gui LIBDIR="%buildroot%_libdir"
%makeinstall_std -C mcstrans

# sysvinit
install -m 0755 %SOURCE1 %buildroot%_initddir/restorecond
install -m 0755 %SOURCE2 %buildroot%_initddir/sandbox
install -m 0755 %SOURCE9 %buildroot%_initddir/mcstrans

# systemd
install -pD -m 0644 %SOURCE11 %buildroot%_unitdir/restorecond.service
install -pD -m 0644 %SOURCE12 %buildroot%_unitdir/mcstrans.service

for f in system-config-selinux selinux-polgengui; do
	ln -sf consolehelper %buildroot%_bindir/$f
done

desktop-file-install --dir %buildroot%_datadir/applications --add-category Settings %SOURCE5
desktop-file-install --dir %buildroot%_datadir/applications %SOURCE7

install -d -m 0755 %buildroot{%_datadir/mcstrans,%_sysconfdir/selinux/mls/setrans.d}
cp -r mcstrans/share/* %buildroot%_datadir/mcstrans/

%find_lang %name


%triggerin -- selinux-policy
[ -f %_datadir/selinux/devel/include/build.conf ] && sepolgen-ifgen ||:


%post restorecond
%post_service restorecond

%preun restorecond
%preun_service restorecond


%post mcstransd
%post_service mcstrans

%preun mcstransd
%preun_service mcstrans

%add_python_req_skip yum
# May also add: gnome, gi, gtk

#
# stanv@ note:
# Fedora spec file has additional sub-packages: -python, -python3. 
# Put it contents here, to main policycoreutils package
#
%files -f %name.lang
/sbin/restorecon
/sbin/fixfiles
/sbin/setfiles
%_sbindir/load_policy
/sbin/load_policy
%_sbindir/genhomedircon
%_sbindir/setsebool
%_sbindir/semodule
%_sbindir/sestatus
%_bindir/secon
%_libexecdir/selinux/hll/
%config(noreplace) %_sysconfdir/sestatus.conf

#
# Fedora python sub-package
#
%_sbindir/semanage
%_bindir/chcat
%_bindir/audit2allow
%_bindir/audit2why
%_bindir/semodule_package
%python_sitelibdir/seobject.py*
%dir %python_sitelibdir/sepolicy
%{python_sitelibdir}/sepolicy/*so
%{python_sitelibdir}/sepolicy/templates
%{python_sitelibdir}/sepolicy/__init__.py*
%{python_sitelibdir}/sepolicy/booleans.py*
%{python_sitelibdir}/sepolicy/communicate.py*
%{python_sitelibdir}/sepolicy/interface.py*
%{python_sitelibdir}/sepolicy/manpage.py*
%{python_sitelibdir}/sepolicy/network.py*
%{python_sitelibdir}/sepolicy/transition.py*
%{python_sitelibdir}/sepolicy/sedbus.py*

#
# Policy Kit config, send_destination="org.selinux"
#
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.selinux.conf
%{python_sitelibdir}/sepolicy*.egg-info
%dir /var/lib/selinux

#
# Fedora doesn't pack them.
# run_init isn't required for systemd
%_sbindir/run_init
%_sbindir/open_init_pty
%config(noreplace) %_sysconfdir/pam.d/run_init

%_datadir/bash-completion/completions/semanage
%_datadir/bash-completion/completions/setsebool

%_man5dir/selinux_config.*
%_man5dir/sestatus.conf*
%_man8dir/fixfiles.*
%_man8dir/load_policy.*
%_man8dir/restorecon.*
%_man8dir/semodule.*
%_man8dir/sestatus.*
%_man8dir/setsebool.*
%_man8dir/setfiles.*
%_man1dir/audit2allow.*
%_man1dir/audit2why.*
%_man8dir/chcat.*
%_man8dir/semanage.*
%_man8dir/semanage-*.*
%_man8dir/semodule_package.*
%_man1dir/secon.*
%_man8dir/genhomedircon.*
# Remove ?
%_man8dir/open_init_pty.*
%_man8dir/run_init.*


%files newrole
%config(noreplace) %_sysconfdir/pam.d/newrole
%attr(4511,root,root) %_bindir/newrole
%_man1dir/newrole.*

#
# stanv@:
# sandbox - useless for selinux-policy-altlinux.
# Leave it for ref-policy.
#
%files sandbox
%_bindir/sandbox
%_sbindir/seunshare
%_initddir/sandbox
%config(noreplace) %_sysconfdir/sysconfig/sandbox
%_man5dir/sandbox.*
%_man8dir/sandbox.*
%_man8dir/seunshare.*


%files sandbox-x
%_datadir/sandbox


%files restorecond
%_unitdir/restorecond.service
%_datadir/dbus-1/services/org.selinux.Restorecond.service
%_sbindir/restorecond
%_initddir/restorecond
%config(noreplace) %_sysconfdir/selinux/restorecond*
%_man8dir/restorecond.*

%files mcstransd
/sbin/mcstransd
%_initrddir/mcstrans
%_unitdir/mcstrans.service
%dir %_sysconfdir/selinux/mls/setrans.d
%_man8dir/mcs.*
%_man8dir/mcstransd.*
%_man8dir/setrans.conf.*
%_datadir/mcstrans

# stanv@
# generate.py does:
# --> from templates import executable
# But, 'templates' is a part of 'sepolicy' python module, as a generate.py
# So /usr/lib/rpm/python.req.py generates wrong dependency:
# python2.7(templates)
# Easiest way do next and add explicit requires.
%add_python_req_skip templates

%files devel
%_bindir/sepolgen
%_bindir/sepolgen-ifgen
%_bindir/sepolgen-ifgen-attr-helper
%_bindir/sepolicy
%python_sitelibdir/sepolicy/generate.py*
%_bindir/semodule_deps
%_bindir/semodule_expand
%_bindir/semodule_link
%_bindir/semodule_unpackage

%_datadir/bash-completion/completions/sepolicy

%_man8dir/sepolgen.*
%_man8dir/sepolicy-booleans.*
%_man8dir/sepolicy-generate.*
%_man8dir/sepolicy-interface.*
%_man8dir/sepolicy-network.*
%_man8dir/sepolicy.*
%_man8dir/sepolicy-communicate.*
%_man8dir/sepolicy-manpage.*
%_man8dir/sepolicy-transition.*
%_man8dir/semodule_deps.*
%_man8dir/semodule_expand.*
%_man8dir/semodule_link.*
%_man8dir/semodule_unpackage.*


%files gui
%_bindir/system-config-selinux
%_bindir/selinux-polgengui

%_datadir/applications/system-config-selinux.desktop
%_datadir/applications/selinux-polgengui.desktop

%_iconsdir/hicolor/24x24/apps/system-config-selinux.png
%_pixmapsdir/system-config-selinux.png

%dir %_datadir/system-config-selinux
%_datadir/system-config-selinux/*.py*
%_datadir/system-config-selinux/*png
%_datadir/system-config-selinux/*.glade

%_xdgconfigdir/autostart/restorecond.desktop

%python_sitelibdir/sepolicy/gui.py*
%python_sitelibdir/sepolicy/sepolicy.glade

%dir %python_sitelibdir/sepolicy/help
%python_sitelibdir/sepolicy/help/*.py*
%python_sitelibdir/sepolicy/help/*.txt
%python_sitelibdir/sepolicy/help/*.png

%config(noreplace) %_sysconfdir/pam.d/system-config-selinux
%config(noreplace) %_sysconfdir/pam.d/selinux-polgengui
%config(noreplace) %_sysconfdir/security/console.apps/system-config-selinux
%config(noreplace) %_sysconfdir/security/console.apps/selinux-polgengui

%_datadir/polkit-1/actions/org.selinux.policy
%_datadir/polkit-1/actions/org.selinux.config.policy
%_datadir/dbus-1/system-services/org.selinux.service

%_man8dir/system-config-selinux.*
%_man8dir/selinux-polgengui.*
%_man8dir/sepolicy-gui*


%changelog
