%define origver 5313

Name: praat
Version: 5.3.13
Release: alt1.1

Summary: A program for speech analysis and synthesis
License: GPL (and others for libraries used)
Group: Sound

Url: http://www.praat.org
Source: http://www.fon.hum.uva.nl/praat/praat%{origver}_sources.tar.gz
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Sun Sep 25 2011
# optimized out: fontconfig fontconfig-devel glib2-devel libX11-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel pkg-config xorg-xproto-devel
BuildRequires: gcc-c++ libalsa-devel libgtk+2-devel

Requires: fonts-bitmap-75dpi

%description
According to its authors, praat is "doing phonetics by computer".
Through its graphical interface, several speech analysis functionalities
are available: spectrograms, cochleograms, and pitch and formant
extraction.  Articulatory synthesis, as well as synthesis from pitch,
formant, and intensity are also available.  Other features are
segmentation, labelling using the phonetic alphabet, and computation
of statistics.  Praat is configurable and extensible through its own
scripting language and has provisions for communicating with other
programs.

* Make sure you have read the Intro from Praat's Help menu.
* If that does not help, use the Search button in Praat's manual window.
* Or consult the Frequently Asked Questions on the website.

Recommends: fonts-bitmap-100dpi fonts-bitmap-75dpi

%prep
%setup -n sources_%origver

%build
cp -a makefiles/makefile.defs.linux makefile.defs
echo "CC += `pkg-config --cflags gtk+-2.0`" >> makefile.defs
echo "LIBS += `pkg-config --libs gtk+-2.0` -lpthread" >> makefile.defs
%make_build

%install
install -pDm755 %name %buildroot%_bindir/%name

%files
%_bindir/*

# TODO:
# - FLAC/ and audio/ are patched
# - GSL/ *seems* just bundled?
# - watch file:
# version=3
#opts="uversionmangle=s/\.0?(\d+)/\.$1/g" \
#  http://www.fon.hum.uva.nl/praat/download_sources.html praat(\d)(\d)(\d+)_sources.tar.gz debian

%changelog
