Name: prelink
Version: 0.4.4
Release: alt2

Summary: An ELF prelinking utility
License: GPLv2+
Group: System/Base

# http://pkgs.fedoraproject.org/repo/pkgs/prelink/prelink-20101123.tar.bz2/f207dafd3f87f9ffc9cf2c6f8016e3b9/prelink-20101123.tar.bz2
Source: prelink-20101123.tar
Source2: prelink.conf
Source3: prelink.cron
Source4: prelink.sysconfig

# Automatically added by buildreq on Sat Nov 18 2006
BuildRequires: gcc-c++ libelf-devel

ExclusiveArch: %ix86 alpha sparc sparc64 s390 s390x x86_64 ppc ppc64

%description
This package contains a utility which modifies ELF shared libraries and
executables, so that far less relocations need to be resolved at runtime
and thus programs come up faster.

%prep
%setup -n prelink
sed -i 's/-Wl,--dynamic/-Wl,--no-as-needed,--dynamic/' \
	testsuite/{functions,Makefile}.*
sed -i 's/ -shared /&-Wl,--no-as-needed /' testsuite/*.sh

%build
%add_optflags -D_GNU_SOURCE
%configure --enable-shared
sed -i 's,-all-static,,' src/Makefile
%make_build
make -k -C testsuite check-harder ||:
make -k -C testsuite check-cycle ||:

%install
%makeinstall

mkdir -p %buildroot%_man5dir
ln -s ../man8/prelink.8 %buildroot%_man5dir/prelink.conf.5

mkdir -p %buildroot/etc/{sysconfig,prelink.conf.d,cron.daily,rpm/macros.d}
install -pm644 %_sourcedir/prelink.conf %buildroot/etc/
install -pm700 %_sourcedir/prelink.cron %buildroot/etc/cron.daily/prelink
install -pm644 %_sourcedir/prelink.sysconfig %buildroot/etc/sysconfig/prelink

cat > %buildroot/etc/rpm/macros.d/prelink <<"EOF"
# rpm verifies prelinked libraries using a prelink undo helper.
#     Note: The 2nd token is used as argv[0] and "library" is a
#     placeholder that will be deleted and replaced with the appropriate
#     library file path.
%%__prelink_undo_cmd     %_sbindir/prelink prelink -y library
EOF
chmod 644 %buildroot/etc/rpm/macros.d/prelink

mkdir -p %buildroot/var/{lib,log}/prelink
touch %buildroot/var/lib/prelink/full
touch %buildroot/var/lib/prelink/quick
touch %buildroot/var/lib/prelink/force
touch %buildroot/var/log/prelink/prelink.log

%post
touch /var/lib/prelink/force

%files
%doc AUTHORS doc/prelink.pdf
%verify(not md5 size mtime) %config(noreplace) /etc/prelink.conf
%verify(not md5 size mtime) %config(noreplace) /etc/sysconfig/prelink
/etc/rpm/macros.d/prelink
%dir %_sysconfdir/prelink.conf.d/
/etc/cron.daily/prelink
%_sbindir/prelink
%_bindir/execstack
%_man5dir/prelink.*
%_man8dir/prelink.*
%_man8dir/execstack.*
%dir /var/lib/prelink/
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/lib/prelink/full
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/lib/prelink/quick
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/lib/prelink/force
%attr(0750,root,adm) %dir /var/log/prelink/
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/log/prelink/prelink.log

%changelog
