Name: procmail
Version: 3.22
Release: alt9

Summary: The procmail mail processing program
License: GPLv2+ or Artistic
Group: Networking/Mail

# ftp://ftp.procmail.org/pub/procmail/procmail-%version.tar.gz
Source: procmail-%version.tar
Source1: README.Maildir
Source2: mailstat.1

Patch1: procmail-3.22-deb-fixes.patch
Patch2: procmail-3.22-owl-alt-fixes.patch
Patch3: procmail-3.22-owl-alt-config.patch
Patch4: procmail-3.22-deb-alt-doc.patch
Patch5: procmail-3.22-owl-truncate.patch
Patch6: procmail-3.22-taviso-bound.patch

Provides: MDA
# This procmail requires useradd with mailspool support installed.
Requires: shadow-utils >= 0:20000902-alt3

# Automatically added by buildreq on Tue May 15 2001
BuildRequires: sendmail-common

%description
procmail is a mail processing program which can be used to filter,
sort, or selectively forward e-mail messages.  Also, procmail is
installed by default as the local delivery agent.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p0

find -type f -name \*.orig -delete

find -type f -print0 |
	xargs -r0 grep -FZl /usr/ucb/mail -- |
	xargs -r0 sed -i 's|/usr/ucb/mail|/bin/mail|g' --

find -type f -print0 |
	xargs -r0 grep -FZl getline -- |
	xargs -r0 sed -i 's/getline/get_line/g' --

sed -i 's,\(/usr\)\(/spool\)\?/mail,/var\2/mail,g' examples/advanced FAQ

install -pm644 %_sourcedir/README.Maildir .
bzip2 -9k HISTORY

%build
%make_build \
	CC=%__cc \
	CFLAGS0="%optflags -fpie -fno-strict-aliasing -Wno-comment -Wno-parentheses -Wno-unused `getconf LFS_CFLAGS`" \
	LDFLAGS0='-pie -Wl,-z,relro,-z,now' \
	LOCKINGTEST=100 \
	SEARCHLIBS=-lm \
	#

%install
mkdir -p %buildroot{%_bindir,%_mandir/man{1,5}}
%make_install install \
        BASENAME=%buildroot%_prefix \
        MANDIR=%buildroot%_mandir

install -pm644 %_sourcedir/mailstat.1 %buildroot%_man1dir/

%files
%_bindir/*
%_mandir/man?/*
%doc Artistic FAQ FEATURES HISTORY.bz2 KNOWN_BUGS README README.Maildir examples

%changelog
