# find-requires: message.h:112:18: fatal error: vector: No such file or directory
%add_findreq_skiplist /usr/include/google/protobuf/message.h
%add_findprov_skiplist /usr/include/google/protobuf/message.h

%define soversion 7
%define _name protobuf

Name: %{_name}-compat%{soversion}
Version: 2.4.1
Release: alt4
Summary: Protocol Buffers - Google's data interchange format
License: Apache License 2.0
Group: System/Libraries
Url: http://code.google.com/p/protobuf/
Packager: Mikhail A Pokidko <pma@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch2: protobuf-2.4.1-java-fixes.patch

# Automatically added by buildreq on Wed Nov 19 2008
BuildRequires: gcc-c++ python-devel libnumpy-devel zlib-devel

%description
Protocol Buffers are a way of encoding structured data in
an efficient yet extensible format. Google uses Protocol Buffers for
almost all of its internal RPC protocols and file formats.

%package -n lib%{_name}%{soversion}
Summary: Protocol Buffer c++ library.
Group: System/Libraries

Provides: libprotobuf = %version-%release
Provides: libprotobuf-compat77 = %version-%release
Obsoletes: libprotobuf-compat77 < %version-%release

%description -n lib%{_name}%{soversion}
Protocol Buffers are a way of encoding structured data in
an efficient yet extensible format. Google uses Protocol Buffers for
almost all of its internal RPC protocols and file formats.

%package -n lib%{_name}%{soversion}-lite
Summary: Protocol Buffers LITE_RUNTIME libraries
Group: System/Libraries
Provides: libprotobuf-lite = %version-%release
Provides: libprotobuf-compat77-lite = %version-%release
Obsoletes: libprotobuf-compat77-lite < %version-%release

%description -n lib%{_name}%{soversion}-lite
Protocol Buffers built with optimize_for = LITE_RUNTIME.

The "optimize_for = LITE_RUNTIME" option causes the compiler to generate code
which only depends libprotobuf-lite, which is much smaller than libprotobuf but
lacks descriptors, reflection, and some other features.


%prep
%setup -q
%patch -p1
rm -rf java/src/test

# without gtest
rm -rf gtest

%if_with java
%patch2 -p1 -b .java-fixes
rm -rf java/src/test
%endif

%build
iconv -f iso8859-1 -t utf-8 CONTRIBUTORS.txt > CONTRIBUTORS.txt.utf8
mv CONTRIBUTORS.txt.utf8 CONTRIBUTORS.txt

rm -f m4/{lt*,libtool*}.m4
export PTHREAD_LIBS="-lpthread"
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%files -n lib%{_name}%{soversion}
%doc CONTRIBUTORS.txt README.txt examples/
%_libdir/*.so.*
%exclude %_libdir/libprotobuf-lite.so.*

%files -n lib%{_name}%{soversion}-lite
%_libdir/libprotobuf-lite.so.*

%changelog
