Name: psmisc
Version: 22.20
Release: alt1

Summary: Utilities for managing processes on your system
License: GPLv2+
Group: System/Base
Url: http://sourceforge.net/projects/%name/
# git://git.altlinux.org/gears/p/psmisc.git
Source: %name-%version-%release.tar

%def_enable selinux
BuildRequires: libncurses-devel %{?_enable_selinux:libselinux-devel}

%description
This package contains utilities for managing processes on your system:
pstree, killall and fuser.  The pstree command displays a tree structure
of all of the running processes on your system.  The killall command
sends a specified signal (SIGTERM if nothing is specified) to processes
identified by name.  The fuser command identifies the PIDs of processes
that are using specified files or filesystems.

%prep
%setup -n %name-%version-%release
mkdir -p m4

%build
%autoreconf
%configure %{subst_enable selinux} --disable-harden-flags
%make_build

%install
%makeinstall_std
mkdir -p %buildroot/sbin
mv %buildroot%_bindir/fuser %buildroot/sbin/
ln -s ../../sbin/fuser %buildroot%_bindir/

pushd %buildroot%_bindir/
ln -sf pstree pstree.x11
popd

%find_lang %name

%files -f %name.lang
/sbin/*
%_bindir/*
%_man1dir/*
%doc AUTHORS ChangeLog README

%changelog
