Name: puddletag
Version: 1.2.0
Release: alt0.M80P.1

Summary: Feature rich, easy to use tag editor
License: GPLv2 and GPLv3+
Group: File tools

URL: http://puddletag.sourceforge.net/
Source: https://github.com/keithgg/%name/releases/download/v%version/%name-%version.tar.gz

Patch0: %name-1.0.1-translations_dir.diff

BuildArch: noarch

Requires: mutagen >= 1.20
# optional
#Requires: chromaprint >= 0.4

BuildRequires: python-devel python-modules-encodings
BuildRequires: desktop-file-utils libqt4-devel

%description
Puddletag is an audio tag editor. Unlike most taggers, it uses a
spreadsheet-like layout so that all the tags you want to edit by hand are
visible and easily editable.

The usual tag editor features are supported like extracting tag information
from filenames, renaming files based on their tags by using patterns (that you
define, not crappy, uneditable ones).

Then there're Functions, which can do things like replace text, trim, change
the case of tags, etc. Actions can automate repetitive tasks. You can import
your QuodLibet library, lookup tags using MusicBrainz, FreeDB or Amazon (though
it's only good for cover art) and more.

Supported formats: ID3v1, ID3v2 (mp3), MP4 (mp4, m4a, etc.), VorbisComments
(ogg, flac), Musepack (mpc), Monkey's Audio (.ape) and WavPack (wv).

%prep
%setup
%patch0 -p1

%build
%python_build
lrelease-qt4 ./translations/*.ts

%install
%python_install
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Audio \
	--add-category=AudioVideoEditing \
	%buildroot%_desktopdir/puddletag.desktop
mkdir -p %buildroot%_datadir/%name/translations
cp -a ./translations/*.qm %buildroot%_datadir/%name/translations/

%files
%_bindir/*
%python_sitelibdir/*
%_desktopdir/*
%_pixmapsdir/*
%_man1dir/*
%_datadir/%name/translations
%doc NEWS

%changelog
