%define pulseaudio_version 9.0

Name:     pulseaudio-module-xrdp
Version:  0.3
Release:  alt0.M80P.1

Summary:  xrdp sink / source pulseaudio modules
License:  Apache 2.0
Group:    Other
Url:      https://github.com/neutrinolabs/pulseaudio-module-xrdp

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %name-%version.tar
Source1:  pulseaudio-src.tar

BuildRequires: libpulseaudio-devel

BuildRequires: gcc-c++
BuildRequires: intltool jackit-devel libalsa-devel libasyncns-devel
BuildRequires: libavahi-devel libbluez-devel libwebrtc-devel
BuildRequires: libcap-devel libdbus-devel libgdbm-devel libudev-devel
BuildRequires: liblirc-devel libltdl7-devel libsoxr-devel
BuildRequires: libsndfile-devel libspeex-devel libspeexdsp-devel
BuildRequires: libssl-devel libwrap-devel
BuildRequires: libSM-devel libX11-devel libXtst-devel libxcbutil-devel
BuildRequires: libjson-c-devel libgtk+2-devel libGConf-devel
BuildRequires: libfftw3-devel libsbc-devel liborc-devel orc xmltoman
BuildRequires: libsystemd-devel

%description
xrdp implements Audio Output redirection using PulseAudio, which is a
sound system used on POSIX operating systems.

%prep
%setup
tar xf %SOURCE1

%build
%undefine _configure_gettext
# Configure Pulseaudio like pulseaudio.spec
pushd pulseaudio-src
echo "%pulseaudio_version" > .tarball-version
touch config.rpath
%autoreconf
%configure \
    --localstatedir=/var \
    --enable-per-user-esound-socket \
    --enable-adrian-aec \
    --disable-bluez4 \
    --disable-static \
    #
popd
# Build pulseaudio-module-xrdp
%autoreconf
%configure PULSE_DIR=`pwd`/pulseaudio-src
%make_build

%install
%makeinstall_std
rm -f %buildroot%_libdir/pulse-*/modules/*.la

%check
%make_build check

%files
%doc README.md
%_libdir/pulse-*/modules/*.so

%changelog
