%define confdir ext/redhat

Name:    puppet
Version: 5.5.1
Release: alt1.M80P.1

Summary: A network tool for managing many disparate systems
Group:   System/Servers
License: ASL 2.0
URL:     https://puppetlabs.com/

BuildArch: noarch

Source:  %name-%version.tar
Patch:   %name-%version-%release.patch
Source1: client.init
Source2: server.init
Source3: puppet.service
Source4: puppetmaster.service
Source5: puppet-nm-dispatcher

BuildRequires(pre): rpm-build-ruby
BuildRequires: ruby-em-http-request
BuildRequires: ruby-eventmachine
BuildRequires: ruby-facter
BuildRequires: ruby-hashie
BuildRequires: ruby-heredoc_unindent
BuildRequires: ruby-hiera
BuildRequires: ruby-pathspec
BuildRequires: ruby-plist
BuildRequires: ruby-rgen
BuildRequires: ruby-safe_yaml

Requires: shadow-change
Conflicts: ruby-semantic

%filter_from_requires /^ruby(.*\(win32\|windows\|wmi-lite\|semantic\|spec_helper\|#\).*)/d

%description
Puppet lets you centrally manage every important aspect of your
system using a cross-platform specification language that manages
all the separate elements normally aggregated in different files,
like users, cron jobs, and hosts, along with obviously discrete
elements like packages, services, and files.

%package  server
Summary:  Server for the puppet system management tool
Group:    System/Servers
Requires: %name = %version-%release

%description server
Provides the central puppet server daemon which provides manifests
to clients.  The server can also function as a certificate authority
and file server.

%prep
%setup
%patch -p1
chmod +x ext/regexp_nodes/regexp_nodes.rb
# remove vendor copy of libraries and support non-Linux platforms
subst 's/require /#require /' \
       lib/puppet/util/windows.rb
#      lib/puppet/vendor/require_vendored.rb \

rm -rf \
       ext/windows \
       ext/puppet-test \
       lib/puppet/feature/cfacter.rb \
       lib/puppet/util/rdoc \
       lib/puppet/util/windows \
       lib/puppet/vendor/safe_yaml/spec \
       lib/puppet/module_tool/skeleton/templates/generator/spec

echo "require 'rdoc'" > lib/puppet/util/rdoc.rb

# Unbundle
rm -r lib/puppet/vendor/*{pathspec,deep_merge}*

%build

%install
%ruby_vendor install.rb \
	     --destdir=%buildroot \
	     --configdir=/etc/puppet \
	     --codedir=/etc/puppet/code \
	     --localedir=%_datadir/puppet/locale \
	     --vardir=%_localstatedir/puppet \
	     --rundir=%_runtimedir/puppet \
	     --logdir=%_logdir/puppet \
	     --no-rdoc \
	     --no-tests

# SysVInit files
install -Dp -m0644 %confdir/client.sysconfig %buildroot%_sysconfdir/sysconfig/puppet
install -Dp -m0755 %SOURCE1 %buildroot%_initrddir/puppet
install -Dp -m0644 %confdir/server.sysconfig %buildroot%_sysconfdir/sysconfig/puppetmaster
install -Dp -m0755 %SOURCE2 %buildroot%_initrddir/puppetmaster
# Systemd files
install -Dp -m0644 %SOURCE3 %buildroot%_unitdir/puppet.service
ln -s %_unitdir/puppet.service %buildroot%_unitdir/puppetagent.service
install -Dp -m0644 %SOURCE4 %buildroot%_unitdir/puppetmaster.service

install -Dp -m0644 %confdir/logrotate %buildroot%_sysconfdir/logrotate.d/puppet
install -Dp -m0644 conf/fileserver.conf %buildroot%_sysconfdir/puppet/fileserver.conf

# Install the ext/ directory to %%_datadir/%%name
install -d %buildroot%_datadir/%name
cp -a ext/ %buildroot%_datadir/%name

# Create other configuration directories
mkdir -p %buildroot%_sysconfdir/puppet/ssl/{public_keys,certificate_requests,certs,ca/requests,ca/private,ca/signed,private,private_keys}
mkdir -p %buildroot%_sysconfdir/puppet/{code,modules,environments/production/manifests}

# Setup tmpfiles.d config
mkdir -p %buildroot%_sysconfdir/tmpfiles.d
echo "D /var/run/%name 0755 _%name %name -" > \
    %buildroot%_sysconfdir/tmpfiles.d/%name.conf

# Create puppet modules directory for puppet module tool
mkdir -p %buildroot%_sysconfdir/%name/modules

# Create service directory
mkdir -p %buildroot{%_localstatedir,%_logdir,%_var/run}/puppet

# Install NetworkManager dispatcher
install -Dpv %SOURCE5 \
    %buildroot%_sysconfdir/NetworkManager/dispatcher.d/98-%{name}

# remove misc packaging artifacts in source not applicable to rpm
rm -rf %buildroot%_datadir/%name/ext/{gentoo,freebsd,solaris,suse,windows,osx,ips,debian}
rm -rf %buildroot%_datadir/%name/ext/{redhat,systemd}
rm -f %buildroot%_datadir/%name/ext/{build_defaults.yaml,project_data.yaml}
# remove obsoleted checks
rm -rf %buildroot%_datadir/%name/ext/nagios

# Add puppetdb example configuration to puppet.conf
cat >> %buildroot%_sysconfdir/puppet/puppet.conf << END.
# Example of puppetdb integration
#[master]
#storeconfigs = true
#storeconfigs_backend = puppetdb
#report = true
#reports = puppetdb
END.

%pre
%_sbindir/groupadd -r -f puppet
%_sbindir/useradd -r -n -g puppet -d %_localstatedir/puppet -s /dev/null -c Puppet _puppet >/dev/null 2>&1 ||:

%post
%post_service puppet

%preun
%preun_service puppet

%post server
%post_service puppetmaster

%preun server
%preun_service puppetmaster

%files
%_initdir/puppet
%_unitdir/puppet.service
%_unitdir/puppetagent.service
%config(noreplace) %_sysconfdir/tmpfiles.d/%name.conf
%dir %_sysconfdir/puppet
%attr(0771,_puppet,puppet) %dir %_sysconfdir/puppet/ssl
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/public_keys
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/certificate_requests
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/certs
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/requests
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/private
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/signed
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/private
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/private_keys
%dir %_sysconfdir/puppet/environments
%dir %_sysconfdir/puppet/environments/production
%dir %_sysconfdir/puppet/environments/production/manifests
%dir %_sysconfdir/puppet/code
%dir %_sysconfdir/puppet/modules
%config(noreplace) %_sysconfdir/puppet/puppet.conf
%config(noreplace) %_sysconfdir/puppet/auth.conf
%config(noreplace) %_sysconfdir/puppet/hiera.yaml
%config(noreplace) %_sysconfdir/sysconfig/puppet
%config(noreplace) %_sysconfdir/logrotate.d/puppet
%_bindir/puppet
%ruby_sitelibdir/*
%_datadir/%name
%_sysconfdir/NetworkManager/dispatcher.d/98-%{name}
%_man8dir/*
%_man5dir/puppet.conf.5*
%attr(1770,_puppet,puppet) %dir %_localstatedir/puppet
%_localstatedir/puppet/
%attr(1770,_puppet,puppet) %dir %_logdir/puppet
%attr(1770,_puppet,puppet) %dir %_var/run/puppet

%files server
%_initdir/puppetmaster
%_unitdir/puppetmaster.service
%config(noreplace) %_sysconfdir/puppet/fileserver.conf
%config(noreplace) %_sysconfdir/sysconfig/puppetmaster

%changelog
