Name:     puppetdb
Version:  5.1.3
Release:  alt1

Summary:  Centralized Puppet Storage
License:  Apache-2.0
Group:    Other
Url:      https://github.com/puppetlabs/puppetdb

Packager: Mikhail Gordeev <obirvalger@altlinux.org>

Source:   %name-%version.tar

BuildArch:      noarch

BuildPreReq: /proc rpm-build-java

# Requires: puppet
Requires: postgresql
Requires: clojure

%def_enable initd

%description
PuppetDB is the fast, scalable, and reliable data warehouse for Puppet. It
caches data generated by Puppet, and gives you advanced features at awesome
speed with a powerful API.

%prep
%setup

%install
install -D %name.jar %buildroot%_javadir/%name/%name.jar
install -D %name.service %buildroot%_unitdir/%name.service
install -D config.ini %buildroot%_sysconfdir/%name/config.ini
mkdir -p %buildroot%_localstatedir/%name

%if_enabled initd
install -D %name.init %buildroot%_initdir/%name
mkdir -p %buildroot%_sysconfdir/tmpfiles.d
cat >%buildroot%_sysconfdir/tmpfiles.d/%name.conf <<EOF
d /var/run/puppetdb 0775 _puppetdb _puppetdb -
EOF
mkdir -p %buildroot%_runtimedir/%name
%endif

%pre
getent group _puppetdb > /dev/null || groupadd -r _puppetdb || :
useradd -r --gid _puppetdb --home %_localstatedir/%name --shell $(which nologin) \
    --comment "puppetdb daemon"  _puppetdb || :

%files
%_javadir/%name/%name.jar
%_unitdir/%name.service
%dir %_sysconfdir/%name
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/config.ini
%dir %attr(0770,_puppetdb,_puppetdb) %_localstatedir/%name
%if_enabled initd
%_initdir/%name
%_sysconfdir/tmpfiles.d/%name.conf
%_runtimedir/%name
%doc README.md
%endif

%changelog
