Name: pve-docs
Summary: PVE Documentation
Version: 5.2.3
Release: alt1
License: GPLv3
Group: Documentation
Url: https://git.proxmox.com/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar

ExclusiveArch: x86_64
BuildArch: noarch
BuildRequires: asciidoc-a2x source-highlight xmlto librsvg-utils mailcap pve-common
BuildRequires: perl(MediaWiki/API.pm) perl(JSON.pm)

%description
PVE Documentation files

%package -n pve-doc-generator
Summary: Proxmox VE Documentation helpers
Group: Documentation
Requires: asciidoc-a2x source-highlight xmlto

%description -n pve-doc-generator
Tool to auto-generate various Proxmox VE Documentation files

%add_findreq_skiplist %_datadir/pve-doc-generator/*.pl

%prep
%setup -q -n %name-%version
grep 'proxmox.com' * -rl | while read f; do
	sed -i 's|proxmox.com|basealt.ru|' $f
done

rm -f getting-help.adoc howto-improve-pve-docs.adoc pve-package-repos.adoc pve-faq.adoc

%build
%make

%install
mkdir -p %buildroot%_datadir/pve-doc-generator/asciidoc
cp *.adoc *.pl *.mk *.xml %buildroot%_datadir/pve-doc-generator/
cp asciidoc/*pve*.conf %buildroot%_datadir/pve-doc-generator/asciidoc/
install -pD -m755 asciidoc-pve %buildroot%_bindir/asciidoc-pve

mkdir -p %buildroot%_datadir/%name/{api-viewer,images/screenshot}
install -m644 *.html %buildroot%_datadir/%name/
install -m644 api-viewer/apidoc.js %buildroot%_datadir/%name/api-viewer/
install -m644 api-viewer/index.html %buildroot%_datadir/%name/api-viewer/
install -m644 images/screenshot/*.png %buildroot%_datadir/%name/images/screenshot/

%files
%_datadir/%name

%files -n pve-doc-generator
%_bindir/asciidoc-pve
%_datadir/pve-doc-generator

%changelog
