Name: pve-manager
Summary: The Proxmox Virtual Environment
Version: 5.2.3
Release: alt8.1
License: GPLv3
Group: System/Servers
Url: https://git.proxmox.com/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

ExclusiveArch: x86_64
Requires: cstream lzop pve-vncterm pve-novnc pve-spiceterm pve-xtermjs pve-docs
Requires: perl-LWP-Protocol-https pve-cluster >= 5.0.27

Source0: pve-manager.tar.xz
Source1: pve-container.tar.xz
Source2: pve-firewall.tar.xz
Source3: pve-ha-manager.tar.xz
Source4: qemu-server.tar.xz

Source10: pve-guest-common.tar.xz
Source11: pve-http-server.tar.xz
Source12: extjs.tar.xz
Source13: pve-widget-toolkit.tar.xz
Source14: pve-i18n.tar.xz

Source5: pve-manager-ru.po
Source6: basealt_logo.png
Source70: basealt_bootsplash.svg
Source71: basealt_bootsplash_yellow.jpg
Source72: basealt_bootsplash_blue.jpg
Source8: basealt_favicon.ico
Source9: basealt_logo-128.png

Patch0: pve-manager-www.patch
Patch1: pve-manager-alt.patch
Patch2: pve-firewall-alt.patch
Patch3: pve-ha-manager-alt.patch
Patch4: pve-container-alt.patch
Patch5: qemu-server-alt.patch
Patch6: pve-manager-alt-bps-to-bit.patch
Patch7: pve-container-altlinux-lxc.patch
Patch8: pve-manager-alt-gzip.patch
Patch9: pve-manager-alt-pve.patch
Patch10: pve-manager-help.patch
Patch11: pve-manager-install_vzdump_cron_config.patch
Patch12: qemu-server-lsi.patch
Patch13: pve-manager-lsi.patch
Patch14: pve-container-lxc.patch
Patch15: pve-manager-ceph.patch
Patch18: pve-container-lxcnetdelbr.patch
Patch19: pve-manager-snapshot-resize.patch
Patch20: pve-manager-rem-package-ver-btn.patch
Patch21: pve-http-server-alt.patch
Patch22: extjs-alt.patch
Patch23: qemu-server-migrate-local-devices.patch
Patch24: pve-manager-postfix-ntpd.patch
Patch25: pve-manager-gettext.patch
Patch26: pve-ha-manager-watchdog.patch
Patch27: pve-widget-toolkit-alt.patch
Patch28: pve-widget-toolkit-alt-utils.patch
Patch29: pve-manager-widgettoolkit.patch
Patch30: qemu-server-perl-alt.patch
Patch31: qemu-server-qemu-3-0-0-alt.patch
Patch32: pve-manager-alt-rm-pve-version.patch
Patch33: pve-container-pct-T.patch
Patch34: qemu-server-alt-bootsplash.patch
Patch35: pve-manager-logrotate.patch

BuildRequires: glib2-devel libnetfilter_log-devel pve-doc-generator pve-storage librados2-perl libsystemd-daemon-devel
BuildRequires: perl-AnyEvent-AIO perl-AnyEvent-HTTP perl-AptPkg perl-Crypt-SSLeay perl-File-ReadBackwards
BuildRequires: perl-IO-Multiplex perl-Locale-PO perl-UUID unzip xmlto pve-lxc
BuildRequires: perl(File/Sync.pm) perl(Net/DNS/Resolver.pm) perl(Pod/Select.pm) perl(Crypt/Eksblowfish/Bcrypt.pm)
BuildRequires: perl(Template.pm) perl(IPC/Run.pm)

%description
This package contains the PVE management tools

%package -n pve-container
Summary: PVE Container management tool
Version: 2.0.24
Group: Development/Perl
PreReq: shadow-submap
Requires: pve-lxc >= 2.1.0 dtach perl-Crypt-Eksblowfish >= 0.009-alt5_15

%description -n pve-container
Tool to manage Linux Containers on PVE

%package -n pve-firewall
Summary: PVE Firewall
Version: 3.0.12
Group: System/Servers
Requires: ebtables ipset iptables iptables-ipv6 shorewall shorewall6 iproute2 >= 4.10.0

%description -n pve-firewall
This package contains the PVE Firewall

%package -n pve-ha-manager
Summary: PVE HA Manager
Version: 2.0.5
Group: System/Servers

%description -n pve-ha-manager
HA Manager PVE

%package -n pve-qemu-server
Summary: Qemu Server Tools
Version: 5.0.27
Group: System/Servers
Requires: socat genisoimage cloud-init pve-qemu-system >= 2.6.1-alt4
Provides: qemu-server = %version-%release
Obsoletes: qemu-server < %version-%release

%description -n pve-qemu-server
This package contains the Qemu Server tools used by PVE

%package -n pve-guest-common
Summary: PVE common guest-related modules
Version: 2.0.17
Group: System/Servers

%description -n pve-guest-common
This package contains a common code base used by pve-container and qemu-server

%package -n pve-http-server
Summary: PVE Asynchrounous HTTP Server Implementation
Version: 2.0.11
Group: System/Servers
Requires: fonts-font-awesome

%description -n pve-http-server
This is used to implement the PVE REST API

%add_findreq_skiplist %perl_vendor_privlib/PVE/HA/Env/PVE2.pm

%prep
%setup -q -c -n pve -a1 -a2 -a3 -a4 -a10 -a11 -a12 -a13 -a14
%patch0 -p0 -b .altwww
%patch1 -p0 -b .alt
%patch2 -p0 -b .alt
%patch3 -p0 -b .alt
%patch4 -p0 -b .alt
%patch5 -p0 -b .alt
%patch6 -p0 -b .alt-bps-to-bit
%patch7 -p0 -b .altlinux-lxc
%patch8 -p0 -b .alt-gzip
%patch9 -p0 -b .alt-pve
%patch10 -p0 -b .alt-help
%patch11 -p0 -b .vzdump
%patch12 -p0 -b .megasas-gen2-1
%patch13 -p0 -b .megasas-gen2-2
%patch14 -p0 -b .lxc
%patch15 -p0 -b .ceph
%patch18 -p0 -b .lxcnetdelbr
%patch19 -p0 -b .resize
%patch20 -p0 -b .rembtn
%patch21 -p0 -b .alt
%patch22 -p0 -b .alt
%patch23 -p0 -b .local-devices
%patch24 -p0 -b .postfix-3
%patch25 -p0 -b .gettext
%patch26 -p0 -b .watchdog
%patch27 -p0 -b .alt
%patch28 -p0 -b .alt
%patch29 -p0 -b .widgettoolkit
%patch30 -p0 -b .perl-compat
%patch31 -p0 -b .qemu-3-0-0
%patch32 -p0 -b .rm-version
%patch33 -p0 -b .T
%patch34 -p0 -b .bootsplash
%patch35 -p1 -b .logrotate

install -m0644 %SOURCE5 pve-i18n/ru.po

%build
for d in pve-manager pve-firewall/src pve-ha-manager/src pve-widget-toolkit; do
    pushd $d
    %make
    popd
done

%install
for d in pve-manager pve-firewall/src pve-ha-manager/src pve-container/src qemu-server pve-guest-common pve-http-server extjs pve-widget-toolkit pve-i18n; do
    pushd $d
    %make DESTDIR=%buildroot install
    popd
done

install -m0644 %SOURCE6 %buildroot%_datadir/pve-manager/images/basealt_logo.png
install -m0644 %SOURCE8 %buildroot%_datadir/pve-manager/images/favicon.ico
install -m0644 %SOURCE9 %buildroot%_datadir/pve-manager/images/logo-128.png

install -m0644 %SOURCE71 %buildroot%_datadir/qemu-server/bootsplash.jpg
install -m0644 %SOURCE72 %buildroot%_datadir/qemu-server/bootsplash_invert.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-cirrus.jpg
ln -s bootsplash_invert.jpg %buildroot%_datadir/qemu-server/bootsplash-std.jpg
ln -s bootsplash_invert.jpg %buildroot%_datadir/qemu-server/bootsplash-vmware.jpg
ln -s bootsplash_invert.jpg %buildroot%_datadir/qemu-server/bootsplash-qxl.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial0.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial1.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial2.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial3.jpg

install -m0644 pve-firewall/debian/*.service %buildroot%systemd_unitdir/
install -m0644 pve-firewall/debian/pve-firewall.logrotate %buildroot%_sysconfdir/logrotate.d/pve-firewall
mkdir -p %buildroot%_localstatedir/pve-firewall

install -m0644 pve-ha-manager/debian/*.service %buildroot%systemd_unitdir/
install -pD -m0644 pve-ha-manager/debian/pve-ha-manager.default %buildroot%_sysconfdir/sysconfig/pve-ha-manager

mkdir -p %buildroot/lib/tmpfiles.d
cat << __EOF__ > %buildroot/lib/tmpfiles.d/%name.conf
d /var/run/pveproxy 0700 www-data www-data -
f /var/lock/pveproxy.lck 0644 www-data www-data
f /var/lock/spiceproxy.lck 0644 www-data www-data
__EOF__

mkdir -p %buildroot%_sysconfdir/modules-load.d
cat << __EOF__ > %buildroot%_sysconfdir/modules-load.d/pve-firewall.conf
br_netfilter
__EOF__

%post
%post_service pvedaemon
%post_service pveproxy
%post_service pvestatd
%post_service spiceproxy

%preun
%preun_service pvedaemon
%preun_service pveproxy
%preun_service pvestatd
%preun_service spiceproxy

%post -n pve-container
%_sbindir/usermod --add-subgids 100000-165535 root ||:
%_sbindir/usermod --add-subuids 100000-165535 root ||:

%post -n pve-firewall
%post_service pve-firewall
%post_service pvefw-logger

%preun -n pve-firewall
%preun_service pve-firewall
%preun_service pvefw-logger

%files
%dir %_datadir/doc/pve-manager
%_datadir/doc/pve-manager/examples
%_sysconfdir/bash_completion.d/pveam
%_sysconfdir/bash_completion.d/pvesr
%_sysconfdir/bash_completion.d/pveceph
%_sysconfdir/bash_completion.d/pvedaemon
%_sysconfdir/bash_completion.d/pvenode
%_sysconfdir/bash_completion.d/pveproxy
%_sysconfdir/bash_completion.d/pvestatd
%_sysconfdir/bash_completion.d/pvesubscription
%_sysconfdir/bash_completion.d/spiceproxy
%_sysconfdir/bash_completion.d/vzdump
%_sysconfdir/logrotate.d/pve
%config(noreplace) %_sysconfdir/vzdump.conf
#systemd_unitdir/pvebanner.service
#systemd_unitdir/pvenetcommit.service
%systemd_unitdir/pvedaemon.service
%systemd_unitdir/pve-guests.service
%systemd_unitdir/pveproxy.service
%systemd_unitdir/pvestatd.service
%systemd_unitdir/spiceproxy.service
%systemd_unitdir/pve-storage.target
%systemd_unitdir/pvesr.*
%systemd_unitdir/ceph-*.service.d
/lib/tmpfiles.d/%name.conf
%_bindir/pveam
%_bindir/pvesr
#_bindir/pvebanner
%_bindir/pveceph
%_bindir/pvedaemon
%_bindir/pvemailforward
%_bindir/pvemailforward.pl
%_bindir/pvenode
%_bindir/pveperf
%_bindir/pveproxy
%_bindir/pvereport
%_bindir/pvesh
%_bindir/pvestatd
#_bindir/pvesubscription
%_bindir/pveupdate
#_bindir/pveupgrade
%_bindir/pveversion
%_bindir/spiceproxy
%_bindir/vzdump
%_datadir/javascript
%_datadir/pve-i18n
%dir %perl_vendor_privlib/PVE
%dir %perl_vendor_privlib/PVE/API2
%dir %perl_vendor_privlib/PVE/CLI
%dir %perl_vendor_privlib/PVE/Service
%dir %perl_vendor_privlib/PVE/Status
%dir %perl_vendor_privlib/PVE/VZDump
%perl_vendor_privlib/PVE/API2.pm
%perl_vendor_privlib/PVE/API2Tools.pm
%perl_vendor_privlib/PVE/APLInfo.pm
%perl_vendor_privlib/PVE/AutoBalloon.pm
%perl_vendor_privlib/PVE/CephTools.pm
%perl_vendor_privlib/PVE/CertHelpers.pm
%perl_vendor_privlib/PVE/HTTPServer.pm
%perl_vendor_privlib/PVE/NodeConfig.pm
%perl_vendor_privlib/PVE/pvecfg.pm
%perl_vendor_privlib/PVE/Report.pm
%perl_vendor_privlib/PVE/VZDump.pm
%perl_vendor_privlib/PVE/API2/ACME.pm
%perl_vendor_privlib/PVE/API2/ACMEAccount.pm
%perl_vendor_privlib/PVE/API2/APT.pm
%perl_vendor_privlib/PVE/API2/Backup.pm
%perl_vendor_privlib/PVE/API2/Ceph.pm
%perl_vendor_privlib/PVE/API2/Certificates.pm
%perl_vendor_privlib/PVE/API2/Cluster.pm
%perl_vendor_privlib/PVE/API2/HAConfig.pm
%perl_vendor_privlib/PVE/API2/Network.pm
%perl_vendor_privlib/PVE/API2/NodeConfig.pm
%perl_vendor_privlib/PVE/API2/Nodes.pm
%perl_vendor_privlib/PVE/API2/Pool.pm
%perl_vendor_privlib/PVE/API2/Services.pm
%perl_vendor_privlib/PVE/API2/Subscription.pm
%perl_vendor_privlib/PVE/API2/Tasks.pm
%perl_vendor_privlib/PVE/API2/VZDump.pm
%perl_vendor_privlib/PVE/API2/Replication.pm
%perl_vendor_privlib/PVE/API2/ReplicationConfig.pm
%perl_vendor_privlib/PVE/CLI/pveceph.pm
%perl_vendor_privlib/PVE/CLI/pvenode.pm
%perl_vendor_privlib/PVE/CLI/pvesr.pm
%perl_vendor_privlib/PVE/CLI/pvesubscription.pm
%perl_vendor_privlib/PVE/CLI/vzdump.pm
%perl_vendor_privlib/PVE/Service/pvedaemon.pm
%perl_vendor_privlib/PVE/Service/pveproxy.pm
%perl_vendor_privlib/PVE/Service/pvestatd.pm
%perl_vendor_privlib/PVE/Service/spiceproxy.pm
%perl_vendor_privlib/PVE/Status/Graphite.pm
%perl_vendor_privlib/PVE/Status/InfluxDB.pm
%perl_vendor_privlib/PVE/Status/Plugin.pm
%perl_vendor_privlib/PVE/CLI/pveam.pm
%_datadir/pve-manager
%_localstatedir/pve-manager
%dir %_localstatedir/vz/images
%dir %_localstatedir/vz/template/iso
%dir %_localstatedir/vz/template/qemu
%attr(0770,root,www-data) %_logdir/pveproxy
%_man1dir/pveceph.1*
%_man1dir/pvenode.1*
%_man1dir/pveperf.1*
%_man1dir/pvereport.1*
%_man1dir/pvesh.1*
%_man1dir/pvesr.1*
#_man1dir/pvesubscription.1*
#_man1dir/pveupgrade.1*
%_man1dir/pveversion.1*
%_man1dir/vzdump.1*
%_man1dir/pveam.1.xz
%_man8dir/pvedaemon.8*
%_man8dir/pveproxy.8*
%_man8dir/pvestatd.8*
%_man8dir/spiceproxy.8*
%dir %_datadir/doc/%name

%files -n pve-container
%_sysconfdir/bash_completion.d/pct
%systemd_unitdir/lxc@.service.d
%systemd_unitdir/pve-container@.service
%systemd_unitdir/system-pve*container.slice
%_sbindir/pct
%_datadir/lxc
%dir %perl_vendor_privlib/PVE
%dir %perl_vendor_privlib/PVE/API2
%dir %perl_vendor_privlib/PVE/CLI
%dir %perl_vendor_privlib/PVE/VZDump
%perl_vendor_privlib/PVE/LXC
%perl_vendor_privlib/PVE/LXC.pm
%perl_vendor_privlib/PVE/API2/LXC
%perl_vendor_privlib/PVE/API2/LXC.pm
%perl_vendor_privlib/PVE/CLI/pct.pm
%perl_vendor_privlib/PVE/VZDump/ConvertOVZ.pm
%perl_vendor_privlib/PVE/VZDump/LXC.pm
%_man1dir/pct.1*
%_man5dir/*ct.conf.5*

%files -n pve-firewall
%_sysconfdir/bash_completion.d/pve-firewall
%_sysconfdir/logrotate.d/pve-firewall
%config(noreplace) %_sysconfdir/sysctl.d/pve-firewall.conf
%config(noreplace) %_sysconfdir/modules-load.d/pve-firewall.conf
%systemd_unitdir/pve-firewall.service
%systemd_unitdir/pvefw-logger.service
%_sbindir/pve-firewall
%_sbindir/pvefw-logger
%dir %perl_vendor_privlib/PVE
%dir %perl_vendor_privlib/PVE/API2
%dir %perl_vendor_privlib/PVE/Service
%perl_vendor_privlib/PVE/Firewall.pm
%perl_vendor_privlib/PVE/FirewallSimulator.pm
%perl_vendor_privlib/PVE/API2/Firewall
%perl_vendor_privlib/PVE/Service/pve_firewall.pm
%_localstatedir/pve-firewall
%_man8dir/pve-firewall.8*

%files -n pve-ha-manager
%config(noreplace) %_sysconfdir/sysconfig/pve-ha-manager
%_sysconfdir/bash_completion.d/ha-manager
%_sysconfdir/bash_completion.d/pve-ha-crm
%_sysconfdir/bash_completion.d/pve-ha-lrm
%systemd_unitdir/pve-ha-crm.service
%systemd_unitdir/pve-ha-lrm.service
%systemd_unitdir/watchdog-mux.service
%_sbindir/ha-manager
%_sbindir/pve-ha-crm
%_sbindir/pve-ha-lrm
%_sbindir/watchdog-mux
%dir %perl_vendor_privlib/PVE
%dir %perl_vendor_privlib/PVE/API2
%dir %perl_vendor_privlib/PVE/CLI
%dir %perl_vendor_privlib/PVE/HA
%dir %perl_vendor_privlib/PVE/Service
%dir %perl_vendor_privlib/PVE/HA/Resources
%perl_vendor_privlib/PVE/API2/HA
%perl_vendor_privlib/PVE/CLI/ha_manager.pm
%perl_vendor_privlib/PVE/HA/Env
%perl_vendor_privlib/PVE/HA/Config.pm
%perl_vendor_privlib/PVE/HA/CRM.pm
%perl_vendor_privlib/PVE/HA/Env.pm
%perl_vendor_privlib/PVE/HA/Groups.pm
%perl_vendor_privlib/PVE/HA/LRM.pm
%perl_vendor_privlib/PVE/HA/Manager.pm
%perl_vendor_privlib/PVE/HA/NodeStatus.pm
%perl_vendor_privlib/PVE/HA/Resources.pm
%perl_vendor_privlib/PVE/HA/Tools.pm
%perl_vendor_privlib/PVE/HA/Fence.pm
%perl_vendor_privlib/PVE/HA/FenceConfig.pm
%perl_vendor_privlib/PVE/Service/pve_ha_crm.pm
%perl_vendor_privlib/PVE/Service/pve_ha_lrm.pm
%perl_vendor_privlib/PVE/HA/Resources/PVEVM.pm
%perl_vendor_privlib/PVE/HA/Resources/PVECT.pm
%_man1dir/ha-manager.1*
%_man8dir/pve-ha-crm.8*
%_man8dir/pve-ha-lrm.8*

%files -n pve-qemu-server
%_sysconfdir/bash_completion.d/qm
%_sysconfdir/bash_completion.d/qmrestore
%config(noreplace) %_sysconfdir/modules-load.d/qemu-server.conf
%_prefix/lib/qemu-server
%_sbindir/qm
%_sbindir/qmrestore
%dir %perl_vendor_privlib/PVE
%dir %perl_vendor_privlib/PVE/API2
%dir %perl_vendor_privlib/PVE/API2/Qemu
%dir %perl_vendor_privlib/PVE/CLI
%dir %perl_vendor_privlib/PVE/VZDump
%dir %perl_vendor_privlib/PVE/QemuServer
%perl_vendor_privlib/PVE/QemuMigrate.pm
%perl_vendor_privlib/PVE/QemuServer.pm
%perl_vendor_privlib/PVE/QemuConfig.pm
%perl_vendor_privlib/PVE/QMPClient.pm
%perl_vendor_privlib/PVE/API2/Qemu/Agent.pm
%perl_vendor_privlib/PVE/API2/Qemu.pm
%perl_vendor_privlib/PVE/CLI/qm.pm
%perl_vendor_privlib/PVE/CLI/qmrestore.pm
%perl_vendor_privlib/PVE/VZDump/QemuServer.pm
%perl_vendor_privlib/PVE/QemuServer/Memory.pm
%perl_vendor_privlib/PVE/QemuServer/PCI.pm
%perl_vendor_privlib/PVE/QemuServer/USB.pm
%perl_vendor_privlib/PVE/QemuServer/ImportDisk.pm
%perl_vendor_privlib/PVE/QemuServer/OVF.pm
%perl_vendor_privlib/PVE/QemuServer/Cloudinit.pm
%_datadir/qemu-server
%_localstatedir/qemu-server
%_man1dir/qm.1*
%_man1dir/qmrestore.1*
%_man5dir/*m.conf.5*

%files -n pve-guest-common
%perl_vendor_privlib/PVE/VZDump/Plugin.pm
%perl_vendor_privlib/PVE/ReplicationState.pm
%perl_vendor_privlib/PVE/ReplicationConfig.pm
%perl_vendor_privlib/PVE/Replication.pm
%perl_vendor_privlib/PVE/GuestHelpers.pm
%perl_vendor_privlib/PVE/AbstractMigrate.pm
%perl_vendor_privlib/PVE/AbstractConfig.pm

%files -n pve-http-server
%perl_vendor_privlib/PVE/APIServer
%_datadir/libpve-http-server-perl

%changelog
