%def_with python3
%def_without check

Name: py
Version: 1.4.34
Release: alt0.M80P.1
Summary: Testing and distributed programming library
License: MIT
Group: Development/Tools
Url: https://github.com/pytest-dev/py
BuildArch: noarch

# https://github.com/pytest-dev/py.git
Source: %name-%version.tar.gz

Requires: python-module-%name = %version-%release

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel python-module-setuptools-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools-tests
%endif

%py_provides py.apipkg py.builtin py.code py.error py.iniconfig py.io py.log py.path py.process py.std py.xmlgen

%description
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

%if_with python3
%package -n python3-module-%name
Summary: Python 3 module of testing and distributed programming library
Group: Development/Python3
%add_python3_req_skip compiler
%py3_provides py.apipkg py.builtin py.code py.error py.iniconfig py.io py.log py.path py.process py.std py.xmlgen

%description -n python3-module-%name
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains python module of py lib.

%package -n python3-module-%name-testing
Summary: Testing for py (Python 3)
Group: Development/Python3

%description -n python3-module-%name-testing
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains testing for py lib.
%endif

%package -n python-module-%name
Summary: Python module of testing and distributed programming library
Group: Development/Python
Conflicts: %name

%description -n python-module-%name
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains python module of py lib.

%package -n python-module-%name-testing
Summary: Testing for py
Group: Development/Python

%description -n python-module-%name-testing
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains testing for py lib.

%package doc
Summary: Documentation for testing and distributed programming library
Group: Development/Documentation

%description doc
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains documentation for py lib.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
rm -fR %buildroot%python_sitelibdir/%name/bin/win32 \
	%buildroot%python_sitelibdir/%name/execnet/script/socketserverservice.py*
cp -fR testing %buildroot%python_sitelibdir/%name/

for i in $(find %buildroot%python_sitelibdir/%name -type d)
do
	touch $i/__init__.py
done

%if_with python3
pushd ../python3
%python3_install
popd
rm -fR %buildroot%python3_sitelibdir/%name/bin/win32 \
	%buildroot%python3_sitelibdir/%name/execnet/script/socketserverservice.py*
cp -fR testing %buildroot%python3_sitelibdir/%name/

for i in $(find %buildroot%python3_sitelibdir/%name -type d)
do
	touch $i/__init__.py
done
%endif

%check
export LC_ALL=en_US.UTF-8
python setup.py test
#py.test
%if_with python3
pushd ../python3
python3 setup.py test
#py.test3
popd
%endif

#files
#_bindir/*

%files -n python-module-%name
%doc AUTHORS CHANGELOG LICENSE *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/%name/testing
%exclude %python_sitelibdir/%name/test.py*

%files -n python-module-%name-testing
%python_sitelibdir/%name/testing
%python_sitelibdir/%name/test.py*

%files doc
%doc doc
#doc hacking

%if_with python3
%files -n python3-module-%name
%doc AUTHORS CHANGELOG LICENSE *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%name/testing
%exclude %python3_sitelibdir/%name/test.py*

%files -n python3-module-%name-testing
%python3_sitelibdir/%name/testing
%python3_sitelibdir/%name/test.py*
%endif

%changelog
