#def_disable check

%def_with python3

Name: pylint
Version: 1.4.4
Release: alt1.1

Summary: Python code static checker
License: GPLv2+
Group: Development/Python

BuildArch: noarch

Url: http://www.pylint.org/
# hg clone https://bitbucket.org/logilab/pylint
Source: %name-%version.tar

%add_findreq_skiplist %python_sitelibdir/%name/gui.py

%setup_python_module %name
#%%py_requires logilab.astng
Requires: python-module-astroid >= 1.0.1

%{?!_without_check:%{?!_disable_check:BuildRequires: /usr/bin/pytest %py_dependencies unittest2 setuptools.tests astroid}}

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-astroid
BuildPreReq: python3-module-unittest2 python3-module-logilab-common
BuildPreReq: python-tools-2to3
%endif

%py_requires astroid logilab.common

%description
Pylint is a Python source code analyzer which looks for programming
errors, helps enforcing a coding standard and sniffs for some code
smells (as defined in Martin Fowler's Refactoring book)

Pylint can be seen as another PyChecker since nearly all tests you
can do with PyChecker can also be done with Pylint. However, Pylint
offers some more features, like checking length of lines of code,
checking if variable names are well-formed according to your coding
standard, or checking if declared interfaces are truly implemented,
and much more.

Additionally, it is possible to write plugins to add your own checks.

%package py3
Summary: Python code static checker
Group: Development/Python3
Requires: python3-module-astroid
%py3_requires astroid logilab.common

%description py3
Pylint is a Python source code analyzer which looks for programming
errors, helps enforcing a coding standard and sniffs for some code
smells (as defined in Martin Fowler's Refactoring book)

Pylint can be seen as another PyChecker since nearly all tests you
can do with PyChecker can also be done with Pylint. However, Pylint
offers some more features, like checking length of lines of code,
checking if variable names are well-formed according to your coding
standard, or checking if declared interfaces are truly implemented,
and much more.

Additionally, it is possible to write plugins to add your own checks.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
rm -rf %buildroot%python3_sitelibdir/%name/test
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install
rm -rf %buildroot%python_sitelibdir/%name/test

%check
PYTHONPATH=$(pwd)/build/lib/ pytest -t test

%files
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/%name
%python_sitelibdir/*.egg-info
%doc ChangeLog README doc/

%if_with python3
%files py3
%_bindir/*.py3
%python3_sitelibdir/%name
%python3_sitelibdir/*.egg-info
%doc ChangeLog README doc/
%endif

%changelog
