# test new macroses
%define python_build CFLAGS="%optflags" python setup.py build
%define python_install python setup.py install --root %buildroot --optimize=2

%define oname BeautifulSoup4

Name: python-module-%oname
Version: 4.6.3
Release: alt0.M80P.1
Summary: HTML/XML parser for quick-turnaround applications like screen-scraping

License: PSF
Group: Development/Python
Url: http://www.crummy.com/software/BeautifulSoup/

BuildArch: noarch

Source: BeautifulSoup-%version.tar

BuildRequires: python-module-pytest
BuildRequires: python-module-setuptools
BuildRequires: time

BuildRequires(pre): rpm-build-python
BuildPreReq: python3-module-pytest
BuildPreReq: python3-module-setuptools


%description
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

%package tests
Summary: Tests for BeautifulSoup4
Group: Development/Python
Requires: %name = %version-%release

%description tests
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

This package contains tests for BeautifulSoup4.

%package -n python3-module-%oname
Summary: HTML/XML parser for quick-turnaround applications like screen-scraping (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

%package -n python3-module-%oname-tests
Summary: Tests for BeautifulSoup4 (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

This package contains tests for BeautifulSoup4.

%prep
%setup -n BeautifulSoup-%version

rm -rf ../python3
cp -a . ../python3

%build
export LC_ALL=en_US.UTF-8
ls
%python_build

pushd ../python3
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build
popd

%install
export LC_ALL=en_US.UTF-8
%python_install

pushd ../python3
%python3_install
popd


%check
export LC_ALL=en_US.UTF-8
python -m unittest discover -s bs4

pushd ../python3
python3 -m unittest discover -s bs4
popd


%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/bs4/test*

%files tests
%python_sitelibdir/bs4/test*

%doc *.txt
%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/bs4/test*
%exclude %python3_sitelibdir/bs4/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/bs4/test*
%python3_sitelibdir/bs4/*/test*


%changelog
