%define oname Chaco
Name: python-module-%oname
Version: 4.6.0
Release: alt1.dev.git20150427
Summary: Interactive 2-Dimensional Plotting

Group: Development/Python
License: BSD and GPLv2
URL: http://code.enthought.com/projects/chaco/
# https://github.com/enthought/chaco.git
Source: %oname-%version.tar.gz
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires: python-devel, python-module-setuptools
#BuildPreReq: libnumpy-devel python-module-traits python-module-Enable
BuildPreReq: libnumpy-devel
BuildPreReq: python-module-sphinx python-module-Pygments

%description
Chaco is a Python plotting application toolkit that facilitates writing
plotting applications at all levels of complexity, from simple scripts with
hard-coded data to large plotting programs with complex data interrelationships
and a multitude of interactive tools. While Chaco generates attractive static
plots for publication and presentation, it also works well for interactive data
visualization and exploration.

%package tests
Summary: Tests for Chaco (Interactive 2-Dimensional Plotting)
Group: Development/Python
Requires: %name = %EVR

%description tests
Chaco is a Python plotting application toolkit that facilitates writing
plotting applications at all levels of complexity, from simple scripts with
hard-coded data to large plotting programs with complex data interrelationships
and a multitude of interactive tools. While Chaco generates attractive static
plots for publication and presentation, it also works well for interactive data
visualization and exploration.

This package contains tests for Chaco.

%package doc
Summary: Documentation for Chaco (Interactive 2-Dimensional Plotting)
Group: Development/Documentation
BuildArch: noarch

%description doc
Chaco is a Python plotting application toolkit that facilitates writing
plotting applications at all levels of complexity, from simple scripts with
hard-coded data to large plotting programs with complex data interrelationships
and a multitude of interactive tools. While Chaco generates attractive static
plots for publication and presentation, it also works well for interactive data
visualization and exploration.

This package contains documentation for Chaco.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%install
%python_install

export PYTHONPATH=%buildroot%python_sitelibdir:$PWD/docs/source/sphinxext
sphinx-build -E -a -b html -c docs/source -d doctrees docs/source html

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*/example*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/*/tests

%files tests
%python_sitelibdir/*/tests
%python_sitelibdir/*/*/tests

%files doc
%doc docs/*.txt docs/*.pdf docs/*.tgz docs/chaco* docs/scipy_tutorial
%doc examples html

%changelog
