%define modname Cython
%def_disable debugger

%def_with python3

Name: python-module-%modname
Version: 0.26
Release: alt0.M80P.1

Summary: C-extensions for Python
Group: Development/Python
License: Python
Url: http://www.cython.org

Source: https://pypi.io/packages/source/C/%modname/%modname-%version.tar.gz

Provides: %modname = %version-%release
Conflicts: python-module-Cython0.18

%if_with  python3
%add_python3_req_skip IPython
%endif

%add_python_req_skip IPython

BuildRequires: rpm-build-python
BuildRequires: python-devel python-module-setuptools python-module-json

%description
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

%package tests
Summary: Cython test suit
Group: Development/Python
Requires: %name = %version-%release
Conflicts: python-module-Cython0.18-tests

%description tests
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

This package provides modules for testing Cython using unittest.

%package debugger
Summary: Cython debugger
Group: Development/Python
Requires: %name = %version-%release
Requires: gdb

%description debugger
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

This package provides modules for debugging Cython programms.

%if_with python3
%package -n python3-module-%modname
Summary: C-extensions for Python3
Group: Development/Python3
# since 0.20.1
%py3_provides cython
Conflicts: python3-module-Cython0.18
BuildRequires: rpm-build-python3
BuildRequires: python3-devel python3-module-distribute

%description -n python3-module-%modname
Cython is a language that makes writing C extensions for the Python3
language as easy as Python3 itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python3
code.

%package -n python3-module-%modname-tests
Summary: Cython test suit for Python3
Group: Development/Python3
Conflicts: python3-module-Cython0.18-tests
Requires: python3-module-%modname = %version-%release

%description -n python3-module-%modname-tests
Cython is a language that makes writing C extensions for the Python3
language as easy as Python3 itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python3
code.

This package provides modules for testing Cython using unittest.

%package -n python3-module-%modname-debugger
Summary: Cython debugger for Python3
Group: Development/Python3
Requires: python3-module-%modname = %version-%release
Requires: gdb

%description -n python3-module-%modname-debugger
Cython is a language that makes writing C extensions for the Python3
language as easy as Python3 itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python3
code.

This package provides modules for debugging Cython programms.
%endif

%prep
%setup -n %modname-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot/%_bindir/cython %buildroot/%_bindir/cython3
mv %buildroot/%_bindir/cygdb %buildroot/%_bindir/cygdb3
%endif

%python_install

%files
%_bindir/cython
%_bindir/cythonize
%python_sitelibdir/pyximport/
%python_sitelibdir/%modname/
%python_sitelibdir/%modname-*egg-info
%python_sitelibdir/cython.py*
%doc *.txt Demos Tools docs

%exclude %python_sitelibdir/%modname/Tests
%exclude %python_sitelibdir/%modname/Debugger

%files tests
%python_sitelibdir/%modname/Tests

%if_enabled debugger
%files debugger
%python_sitelibdir/%modname/Debugger
%_bindir/cygdb
%endif

%if_with python3
%files -n python3-module-%modname
%_bindir/cython3
%python3_sitelibdir/%modname/
%python3_sitelibdir/pyximport/
%python3_sitelibdir/cython.py
%python3_sitelibdir/__pycache__/cython.*
%python3_sitelibdir/*egg-info

%exclude %python3_sitelibdir/%modname/Tests
%exclude %python3_sitelibdir/%modname/Debugger

%files -n python3-module-%modname-tests
%python3_sitelibdir/%modname/Tests

%if_enabled debugger
%files -n python3-module-%modname-debugger
%python3_sitelibdir/%modname/Debugger
%_bindir/cygdb3
%endif
%endif

%changelog
