%define oname FormAlchemy

%def_with python3

Name: python-module-%oname
Version: 1.5.3
Release: alt2.1
Summary: Greatly speeds development with SQLAlchemy mapped classes in a HTML forms environment
License: MIT
Group: Development/Python
Url: http://pypi.python.org/pypi/FormAlchemy/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools python-module-six
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools python3-module-six
%endif

%py_provides %oname

%description
FormAlchemy eliminates boilerplate by autogenerating HTML input fields
from a given model. FormAlchemy will try to figure out what kind of HTML
code should be returned by introspecting the model's properties and
generate ready-to-use HTML code that will fit the developer's
application.

Of course, FormAlchemy can't figure out everything, i.e, the developer
might want to display only a few columns from the given model. Thus,
FormAlchemy is also highly customizable.

%package -n python3-module-%oname
Summary: Greatly speeds development with SQLAlchemy mapped classes in a HTML forms environment
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
FormAlchemy eliminates boilerplate by autogenerating HTML input fields
from a given model. FormAlchemy will try to figure out what kind of HTML
code should be returned by introspecting the model's properties and
generate ready-to-use HTML code that will fit the developer's
application.

Of course, FormAlchemy can't figure out everything, i.e, the developer
might want to display only a few columns from the given model. Thus,
FormAlchemy is also highly customizable.

%package -n python3-module-%oname-tests
Summary: Tests for FormAlchemy
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
FormAlchemy eliminates boilerplate by autogenerating HTML input fields
from a given model. FormAlchemy will try to figure out what kind of HTML
code should be returned by introspecting the model's properties and
generate ready-to-use HTML code that will fit the developer's
application.

Of course, FormAlchemy can't figure out everything, i.e, the developer
might want to display only a few columns from the given model. Thus,
FormAlchemy is also highly customizable.

This package contains tests for FormAlchemy.

%package tests
Summary: Tests for FormAlchemy
Group: Development/Python
Requires: %name = %version-%release

%description tests
FormAlchemy eliminates boilerplate by autogenerating HTML input fields
from a given model. FormAlchemy will try to figure out what kind of HTML
code should be returned by introspecting the model's properties and
generate ready-to-use HTML code that will fit the developer's
application.

Of course, FormAlchemy can't figure out everything, i.e, the developer
might want to display only a few columns from the given model. Thus,
FormAlchemy is also highly customizable.

This package contains tests for FormAlchemy.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
export LC_ALL=en_US.UTF-8

%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
export LC_ALL=en_US.UTF-8

%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc *.txt docs
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%if_with python3
%files -n python3-module-%oname
%doc *.txt docs
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%endif

%changelog
