%define oname Ice
%define major 3.3
Name: python-module-Ice
Version: %major.1
Release: alt5.1

Summary: The Ice runtime for Python applications

License: GPL
Group: System/Libraries
Url: http://www.zeroc.com/

Source: http://www.zeroc.com/download/Ice/%major/Ice-%version.tar.bz2
Source1: http://www.zeroc.com/download/Ice/%major/Ice-rpmbuild-%version.tar.bz2
Patch0: Ice-3.3.1-alt-gcc4.6.patch

%setup_python_module Ice

Requires: libice = %version

Provides: python-module-ice
Obsoletes: python-module-ice

# Automatically added by buildreq on Fri Aug 03 2007
BuildRequires: gcc-c++ ice libice-devel python-devel

BuildRequires: ice = %version

%description
Ice is a modern alternative to object middleware such as CORBA or
COM/DCOM/COM+.  It is easy to learn, yet provides a powerful network
infrastructure for demanding technical applications. It features an
object-oriented specification language, easy to use C++, C#, Java,
Python, Ruby, PHP, and Visual Basic mappings, a highly efficient
protocol, asynchronous method invocation and dispatch, dynamic
transport plug-ins, TCP/IP and UDP/IP support, SSL-based security, a
firewall solution, and much more.

%package -n %name-devel
Summary: Tools for developing Ice applications in Python
Group: Development/Other
Requires: %name = %version-%release
Provides: python-module-ice-devel
Obsoletes: python-module-Ice-devel

%description -n %name-devel
Ice is a modern alternative to object middleware such as CORBA or
COM/DCOM/COM+.  It is easy to learn, yet provides a powerful network
infrastructure for demanding technical applications. It features an
object-oriented specification language, easy to use C++, C#, Java,
Python, Ruby, PHP, and Visual Basic mappings, a highly efficient
protocol, asynchronous method invocation and dispatch, dynamic
transport plug-ins, TCP/IP and UDP/IP support, SSL-based security, a
firewall solution, and much more.

%prep
%setup -n IcePy-%version
%patch0 -p2
ln -s %_datadir/Ice-%version/slice slice
ln -s %_datadir/Ice-%version/certs certs
ln -s %_datadir/Ice-%version/config config
ln -s %_datadir/Ice-%version/config/Make.rules.Linux py/config
mkdir -p cpp
ln -s %_includedir cpp/include
tar xfj %SOURCE1

sed -i 's|^\(CPPFLAGS.*\)|\1 -g -fpermissive|' py/config/Make.rules

%build
cd py
%make_build OPTIMIZE=yes embedded_runpath_prefix="" SLICE2PY=slice2py

%install
cd py

# do not use make_install, it overrides INSTALL_DATA
mkdir -p %buildroot%python_sitelibdir/Ice
echo Ice >%buildroot%python_sitelibdir/Ice.pth
make prefix=%buildroot \
	embedded_runpath_prefix="" \
	install_pythondir=%buildroot%python_sitelibdir/Ice \
	install_libdir=%buildroot%python_sitelibdir/Ice \
	install

rm -f %buildroot/ICE_LICENSE %buildroot/LICENSE
rm -rf %buildroot/slice

%files
%doc ICE_LICENSE LICENSE
%doc py/demo
%python_sitelibdir/Ice/
%python_sitelibdir/Ice.pth

%changelog
