# -*- coding: utf-8 -*-

%define oname MySQLdb
%def_with python3
%def_disable check

Version: 1.2.5
Release: alt1.1.1
Epoch: 1
%setup_python_module %oname
Name: %packagename

Summary: Python interface to MySQL-3.23+
Summary(ru_RU.UTF-8): Интерфейс к MySQL-3.23+ для Python

License: GPLv2
Group: Development/Python
Url: http://sourceforge.net/projects/mysql-python

Source: MySQL-python.tar

BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Fri Jan 29 2016 (-bi)
# optimized out: elfutils python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python-tools-2to3 python3 python3-base python3-module-setuptools
BuildRequires: libmysqlclient-devel python-module-alabaster python-module-docutils python-module-html5lib python-module-nose python-module-objects.inv python-module-pytest python3-devel python3-module-nose python3-module-pytest rpm-build-python3 time

#BuildPreReq: python-module-setuptools-tests
#BuildPreReq: python-module-sphinx-devel
#BuildPreReq: python-module-nose
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-nose
#BuildPreReq: python-tools-2to3
%endif

Obsoletes: MySQL-python <= 0.9.2-alt6
Obsoletes: %name <= %epoch:%version-%release

%description
MySQLdb is an interface to the popular MySQL database server for
Python. The design goals are:

- Compliance with Python database API version 2.0
- Thread-safety
- Thread-friendliness (threads will not block each other)

%description -l ru_RU.UTF-8
MySQLdb - это интерфейс к популярной СУБД MySQL для Python.
При его создании преследовались следующие цели:

- Соответствие API баз данных для Python версии 2.0
- Совместимость с многопоточными средами
- "Дружелюбие к потокам" (потоки не блокируют друг друга)

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
MySQLdb is an interface to the popular MySQL database server for
Python. The design goals are:

- Compliance with Python database API version 2.0
- Thread-safety
- Thread-friendliness (threads will not block each other)

This package contains pickles for %oname.

%package -n python3-module-%oname
Summary: Python interface to MySQL-3.23+
Summary(ru_RU.UTF-8): Интерфейс к MySQL-3.23+ для Python
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
MySQLdb is an interface to the popular MySQL database server for
Python. The design goals are:

- Compliance with Python database API version 2.0
- Thread-safety
- Thread-friendliness (threads will not block each other)

%description -n python3-module-%oname -l ru_RU.UTF-8
MySQLdb - это интерфейс к популярной СУБД MySQL для Python.
При его создании преследовались следующие цели:

- Соответствие API баз данных для Python версии 2.0
- Совместимость с многопоточными средами
- "Дружелюбие к потокам" (потоки не блокируют друг друга)

%prep
%setup -n MySQL-python

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibidr
pushd doc
sphinx-build -b pickle -d _build/doctrees . _build/pickle
sphinx-build -b html -d _build/doctrees . _build/html
popd

cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc HISTORY *.md doc/_build/html
%python_sitelibdir/%modulename
%python_sitelibdir/*egg-info*
%python_sitelibdir/_mysql*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%if_with python3
%files -n python3-module-%oname
%doc HISTORY *.md doc/_build/html
%python3_sitelibdir/*
%endif

%changelog
