# -*- coding: utf-8 -*-

%define oname MySQLdb2
%def_without python3

Version: 1.3.0
Release: alt3.hg20110907
%setup_python_module %oname
Name: %packagename

Summary: Python interface to MySQL-3.23+
Summary(ru_RU.UTF-8): Интерфейс к MySQL-3.23+ для Python
License: GPLv2
Group: Development/Python
Url: http://sourceforge.net/projects/mysql-python
Packager: Python Development Team <python@packages.altlinux.org>

# hg clone http://mysql-python.hg.sourceforge.net:8000/hgroot/mysql-python/MySQLdb-2.0
Source: MySQL-python.tar

# Automatically added by buildreq on Fri Jul 13 2007
BuildRequires: libmysqlclient-devel python-module-setuptools zlib-devel
BuildPreReq: libssl-devel
Conflicts: python-module-MySQLdb
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
%endif

Obsoletes: MySQL-python <= 0.9.2-alt6

%description
MySQLdb is an interface to the popular MySQL database server for
Python.  The design goals are:

- Compliance with Python database API version 2.0

- Thread-safety

- Thread-friendliness (threads will not block each other)

MySQL-3.23 through 5.0 and Python-2.3 through 2.5 are currently
supported.

MySQLdb is Free Software.

%description -l ru_RU.UTF-8
MySQLdb - это интерфейс к популярной СУБД MySQL для Python.
При его создании преследовались следующие цели:

-    Соответствие API баз данных для Python версии 2.0

-    Совместимость с многопоточными средами

-    "Дружелюбие к потокам" (потоки не блокируют друг друга)

-    Совместимость с MySQL-3.23 и более поздними (вплоть до ветки 5.0)

MySQLdb - это свободное ПО.

%if_with python3
%package -n python3-module-%oname
Summary: Python3 interface to MySQL-3.23+
Group: Development/Python3
Conflicts: python3-module-MySQLdb

%description -n python3-module-%oname
MySQLdb is an interface to the popular MySQL database server for
Python.  The design goals are:

- Compliance with Python database API version 2.0

- Thread-safety

- Thread-friendliness (threads will not block each other)
%endif

%prep
%setup -n MySQL-python
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%add_optflags -fno-strict-aliasing
%python_build_debug
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install --optimize=2 --record=INSTALLED_FILES
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files -f INSTALLED_FILES
%doc README HISTORY doc/*
%python_sitelibdir/MySQLdb

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
