%define name numeric
%define version 24.2
%define release alt6
%setup_python_module Numeric

Summary: Numerical Extension to Python
Name: %packagename
Version: %version
Release: %release
Source0: Numeric-%version.tar.gz
Source1: numpy.pdf.bz2
License: Python License
Group: Development/Python
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Prefix: _prefix
Provides: python-module-Numeric 
Obsoletes: python-Numeric
Requires(pre): python-module-arrayfns
Requires: python-module-arrayfns
%py_requires arrayfns
Url: http://www.pfdubois.com/numpy/

Patch0: Numeric-system-lapack.patch

Requires: python

# Automatically added by buildreq on Tue Jul 18 2006
BuildRequires: liblapack-devel python-devel python-modules 
BuildRequires: python-modules-compiler python-modules-encodings


%description

NumPy is a collection of extension modules to provide high-performance
multidimensional numeric arrays to the Python programming language.
Numerical Extension to Python with subpackages.

The authors and maintainers of the subpackages are: 

FFTPACK-3.1
        maintainer = "Numerical Python Developers"
        maintainer_email = "numpy-discussion@lists.sourceforge.net"
        description = "Fast Fourier Transforms"
        url = "http://numpy.sourceforge.net"

MA-12.2.0
        author = "Paul F. Dubois"
        description = "Masked Array facility"
        maintainer = "Paul F. Dubois"
        maintainer_email = "dubois@users.sf.net"
        url = "http://sourceforge.net/projects/numpy"

RNG-3.1
        author = "Lee Busby, Paul F. Dubois, Fred Fritsch"
        maintainer = "Paul F. Dubois"
        maintainer_email = "dubois@users.sf.net"
        description = "Cray-like Random number package."

%package devel
Group: Development/Python
Summary: Python numerical facilities
Requires: %name = %version-%release

Provides: python-numeric-devel python-Numeric-devel
Provides: python-numpy-devel

Obsoletes: python-numpy-devel python-numeric-devel

%description devel
A collection of extension modules to provide high-performance multidimensional
numeric arrays to the Python programming language.
Development files.

%package demo
Group: Development/Python
Summary: Python numerical facilities - demo 

%description demo
A collection of extension modules to provide high-performance multidimensional
numeric arrays to the Python programming language.

Demonstration and testing utilites

%define python_libdir %_libdir/python%_python_version
%define python_site_packages_dir %python_libdir/site-packages
%define python_includedir %_includedir/python%_python_version

%prep
%setup -q -n Numeric-%version 
bzcat %SOURCE1 >numpy.pdf

%patch0 -p 1

%build
env CFLAGS="$RPM_OPT_FLAGS" python setup.py build

%install
%python_install --optimize=2 --record=INSTALLED_FILES

sed -i 's|.*arrayfns\.so$||' INSTALLED_FILES

#find $RPM_BUILD_ROOT -type f | sed -e "s|$RPM_BUILD_ROOT||g" >>INSTALLED_FILES

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat > %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name << EOF
^/usr/lib/python[^/]*/site-packages/Numeric$
EOF

install -d $RPM_BUILD_ROOT/%python_sitelibdir/Numeric/tools/numeric
install -d $RPM_BUILD_ROOT/%python_sitelibdir/Numeric/tools/numeric/NumTut
install -D -m 755 Demo/*py $RPM_BUILD_ROOT/%python_sitelibdir/Numeric/tools/numeric
install -D -m 644 Demo/NumTut/* $RPM_BUILD_ROOT/%python_sitelibdir/Numeric/tools/numeric/NumTut 
install -D -m 755 Test/*test.py $RPM_BUILD_ROOT/%python_sitelibdir/Numeric/tools/numeric

%add_python_lib_path  %_libdir/python%_python_version/site-packages/Numeric

%files -f INSTALLED_FILES
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%doc MANIFEST *README PKG-INFO
%dir %python_sitelibdir/Numeric
%dir %python_sitelibdir/Numeric/FFT
%dir %python_sitelibdir/Numeric/MA
%dir %python_sitelibdir/Numeric/Numeric_headers
%dir %python_sitelibdir/Numeric/RNG
%exclude %python_includedir/Numeric

%files devel
%dir %python_includedir/Numeric
%python_includedir/Numeric/*
%doc numpy.pdf

%files demo
%python_sitelibdir/Numeric/tools/numeric

%changelog
