%define oname OpenGL

%def_with python3

Name: python-module-%oname
Version: 3.1.0
Release: alt2.1.1

Summary: A Python module for interfacing with the OpenGL library
Summary(ru_RU.KOI8-R):   Python     OpenGL

Group: Development/Python
License: see license.txt
Url: http://pyopengl.sourceforge.net

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: PyOpenGL-%version.tar.gz
Patch: PyOpenGL-swig.patch
Patch1: %name.patch

BuildArch: noarch

%setup_python_module OpenGL

#add_python_req_skip WGL__init__
%py_requires OpenGL_accelerate

BuildPreReq: python-module-setuptools python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools python3-devel
BuildPreReq: python-tools-2to3
%endif

%description
OpenGL bindings for Python including support for GL extensions,
GLU, WGL, GLUT, GLE, and Tk

%package -n python3-module-%oname
Summary: A Python module for interfacing with the OpenGL library
Group: Development/Python3
%py3_requires OpenGL_accelerate

%description -n python3-module-%oname
OpenGL bindings for Python including support for GL extensions,
GLU, WGL, GLUT, GLE, and Tk

%package -n python3-module-%oname-tests
Summary: PyOpenGL tests
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%add_python3_req_skip pygame

%description -n python3-module-%oname-tests
PyOpenGL tests.

%package demo
Summary: PyOpenGL demo files
Group: Development/Python
Requires: %name = %version-%release
%add_python_req_skip items win32ui

%description demo
Demo for PyOpenGL

%package doc
Summary: PyOpenGL documentation
Group: Development/Python
Requires: %name = %version-%release

%description doc
PyOpenGL documentation

%package tests
Summary: PyOpenGL tests
Group: Development/Python
Requires: %name = %version-%release

%description tests
PyOpenGL tests.

%prep
%setup -n PyOpenGL-%version

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec \
	sed -i 's|#!%_bindir/python|#!%_bindir/python3|' '{}' +
find ../python3 -type f -name '*.py' -exec \
	sed -i 's|#! %_bindir/env python|#!%_bindir/python3|' '{}' +
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install
touch tests/__init__.py
cp -fR tests %buildroot/%python_sitelibdir/%modulename/

%if_with python3
pushd ../python3
%python3_install
touch tests/__init__.py
cp -fR tests %buildroot/%python3_sitelibdir/%modulename/
popd
%endif

%files
%python_sitelibdir/*.egg-info
%python_sitelibdir/%modulename/
%exclude %python_sitelibdir/%modulename/tests

%files tests
%python_sitelibdir/%modulename/tests

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/%modulename/
%exclude %python3_sitelibdir/%modulename/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/%modulename/tests
%endif

%changelog
