%define version 1.7.5
%define release alt3.hg20120208
%define oname PasteScript

%def_with python3

%setup_python_module %oname

Name: %packagename
Version:%version
Release: alt3.hg20120208.1
Serial: 1

Summary: A pluggable command-line frontend

License: MIT/X11
Group: Development/Python
BuildArch: noarch
Url: http://pythonpaste.org
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# hg clone http://bitbucket.org/ianb/pastescript
Source: %modulename-%version.tar

Conflicts: python-module-paste.script
Obsoletes: python-module-paste.script
%py_provides %oname

BuildRequires: python-module-PasteDeploy
BuildPreReq: python-module-sphinx python-module-Pygments
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-PasteDeploy
BuildPreReq: python3-module-sphinx python3-module-Pygments
BuildPreReq: python-tools-2to3
%endif

%description
A pluggable command-line frontend, including commands to setup
package file layouts.

%if_with python3
%package -n python3-module-%oname
Summary: A pluggable command-line frontend (Python 3)
Group: Development/Python3
%py3_provides %oname
%add_python3_req_skip new

%description -n python3-module-%oname
A pluggable command-line frontend, including commands to setup
package file layouts.
%endif

%prep
%setup -n %modulename-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%if_with python3
pushd ../python3
sed -i 's|%_bindir/env python|%_bindir/env python3|' \
	tests/test_logging_config.py scripts/paster
2to3 -w -n scripts/paster
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build
popd
%endif

%python_build
./regen-docs

%install
%if_with python3
pushd ../python3
%python3_install
mv %buildroot%_bindir/paster %buildroot%_bindir/paster3
popd
%endif
%python_install

%files
%doc docs/_build/*
%python_sitelibdir/paste/script
%python_sitelibdir/%modulename-*
%_bindir/paster
%exclude %python_sitelibdir/tests

%if_with python3
%files -n python3-module-%oname
%_bindir/paster3
%python3_sitelibdir/paste/script
%python3_sitelibdir/%modulename-*
%exclude %python3_sitelibdir/tests
%endif

%changelog
