%define oname PyAMF
Name: python-module-%oname
Version: 0.6.1
Release: alt2
Summary: AMF support for Python
License: MIT
Group: Development/Python
Url: http://pypi.python.org/pypi/PyAMF/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools-tests

Requires: python-module-django

%description
PyAMF provides Action Message Format (AMF) support for Python that is
compatible with the Adobe Flash Player. It includes integration with
Python web frameworks like Django, Pylons, Twisted, SQLAlchemy, web2py
and more.

The Adobe Integrated Runtime and Adobe Flash Player use AMF to
communicate between an application and a remote server. AMF encodes
remote procedure calls (RPC) into a compact binary representation that
can be transferred over HTTP/HTTPS or the RTMP/RTMPS protocol. Objects
and data values are serialized into this binary format, which increases
performance, allowing applications to load data up to 10 times faster
than with text-based formats such as XML or SOAP.

AMF3, the default serialization for ActionScript 3.0, provides various
advantages over AMF0, which is used for ActionScript 1.0 and 2.0. AMF3
sends data over the network more efficiently than AMF0. AMF3 supports
sending int and uint objects as integers and supports data types that
are available only in ActionScript 3.0, such as ByteArray,
ArrayCollection, ObjectProxy and IExternalizable.

%package tests
Summary: Tests for PyAMF
Group: Development/Python
Requires: %name = %version-%release

%description tests
PyAMF provides Action Message Format (AMF) support for Python that is
compatible with the Adobe Flash Player. It includes integration with
Python web frameworks like Django, Pylons, Twisted, SQLAlchemy, web2py
and more.

This package contains tests for PyAMF.

%package docs
Summary: Documentation for PyAMF
Group: Development/Documentation
BuildArch: noarch

%description docs
PyAMF provides Action Message Format (AMF) support for Python that is
compatible with the Adobe Flash Player. It includes integration with
Python web frameworks like Django, Pylons, Twisted, SQLAlchemy, web2py
and more.

This package contains documentation for PyAMF.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%install
%python_install

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%files docs
%doc doc/*

%changelog
