%define oname PyQt4

%def_with python3

Name: python-module-%oname
Version: 4.12.1
Release: alt2%ubt
Summary: Python bindings for Qt4
License: GPL
Group: Development/Python

%setup_python_module %oname

Source0: PyQt-x11-gpl.tar
URL: http://www.riverbankcomputing.co.uk/software/pyqt

#BuildPreReq: %py_package_dependencies sip-devel >= 4.8.1
#BuildPreReq: %py_package_dependencies dbus-devel

%add_python_req_skip Compiler

BuildRequires(pre): rpm-build-ubt python-module-sip-devel
# Automatically added by buildreq on Fri Jan 29 2016 (-bi)
# optimized out: elfutils fontconfig libGL-devel libX11-devel libXext-devel libdbus-devel libgpg-error libgst-plugins1.0 libjson-c libqt4-clucene libqt4-core libqt4-dbus libqt4-declarative libqt4-designer libqt4-devel libqt4-gui libqt4-help libqt4-location libqt4-multimedia libqt4-network libqt4-opengl libqt4-script libqt4-scripttools libqt4-sensors libqt4-sql libqt4-svg libqt4-test libqt4-webkit libqt4-xml libqt4-xmlpatterns libstdc++-devel pkg-config python-base python-devel python-module-dbus python-module-sip python-modules python-modules-compiler python-modules-logging python-modules-xml python3 python3-base python3-dev python3-module-sip
BuildRequires: gcc-c++ libqt4-webkit-devel phonon-devel python-module-dbus-devel

#BuildRequires: gcc-c++ libqt4-devel lout
#BuildPreReq: python-module-qscintilla2-qt4-devel libqscintilla2-qt4-devel
#BuildRequires: python-module-sip-devel python-devel
#BuildPreReq: python-module-dbus-devel phonon-devel

%define sipver2 %(rpm -q --qf '%%{VERSION}' python-module-sip)
Requires: python-module-sip = %sipver2

%if_with python3
BuildRequires(pre): rpm-build-python3 python3-module-sip-devel
#BuildRequires: python3-devel python3-module-sip-devel
#BuildPreReq: python3-module-dbus-devel
#BuildPreReq: python3-module-qscintilla2-qt4-devel
#BuildPreReq: python3-module-sip-devel
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif

%description
Python bindings for the Qt4 C++ class library.  Also includes a PyQt4 backend
code generator for Qt4 Designer.

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 bindings for Qt4
Group: Development/Python3
%add_python3_req_skip Compiler
Requires: python3-module-sip = %sipver3

%description -n python3-module-%oname
Python bindings for the Qt4 C++ class library.  Also includes a PyQt4 backend
code generator for Qt4 Designer.

%package -n python3-module-%oname-devel
Requires: python3-module-%oname = %version-%release
Summary:  Sip files for %name (Python 3)
BuildArch: noarch
Group: Development/Python3
%py3_provides %oname-devel

%description -n python3-module-%oname-devel
Sip files for PyQt4 to build extension
%endif

%package devel
Requires: %name = %version-%release
Summary:  Sip files for %name
BuildArch: noarch
Group: Development/Python
%py_package_provides %modulename-devel = %version-%release

%description devel
Sip files for PyQt4 to build extension

%package examples
Summary: PyQt4 examples
Group: Development/Python
BuildArch: noarch
Requires: %name
%py_package_provides %modulename-examples = %version-%release

%description examples
This package contains PyQt4 examples

%package doc
Summary: PyQt4 docs
Group: Development/Python
BuildArch: noarch
Requires: %name
%py_package_provides %modulename-examples = %version-%release

%description doc
This package contains PyQt4 docs

%prep
%setup -n PyQt-x11-gpl
subst 's|/lib/libpython|/%_lib/libpython|g' configure*.py
subst 's|/lib" |/%_lib" |g' configure*.py
subst 's|#include <QTextStream>|#include <QTextStream>\n#define QT_SHARED\n|g' \
	configure*.py
find . -type f -name \*.pro -o -name '*.pro-in' |while read f; do
cat >> $f << 'E_O_F'
QMAKE_CFLAGS += %optflags %optflags_shared
QMAKE_CXXFLAGS += %optflags %optflags_shared
E_O_F
done

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
export QT4DIR=%_qt4dir
%add_optflags -I%_includedir/kde4 -I%_includedir/kde4/phonon
%add_optflags -I$PWD/qpy/QtGui

#cp -fR ../PyQt-x11-gpl ../_tmp_
#pushd ../_tmp_
#echo 'yes' | python configure.py \
#	--debug \
#	--verbose \
#	-q %_qt4dir/bin/qmake \
#	-d %python_sitelibdir \
#	-p %_qt4dir/plugins \
#	-a --confirm-license \
#	--qsci-api \
#	--enable=designer-plugin \
#	CFLAGS+="%optflags" CXXFLAGS+="%optflags"
#popd

#echo 'yes' | python configure-ng.py \
echo 'yes' | python configure.py \
	--debug \
	--verbose \
	-q %_qt4dir/bin/qmake \
	-d %python_sitelibdir \
	-a --confirm-license \
	--qsci-api \
	CFLAGS+="%optflags" CXXFLAGS+="%optflags"
for i in $(find ./ -name Makefile); do
	sed -i 's|-Wl,-rpath,|-I|g' $i
done
%make_build

%if_with python3
pushd ../python3
echo 'yes' | python3 configure.py \
	--debug \
	--verbose \
	-q %_qt4dir/bin/qmake \
	-d %python3_sitelibdir \
	-p %_qt4dir/plugins \
	-a --confirm-license \
	--qsci-api \
	--no-designer-plugin \
	--sipdir=%_datadir/sip3/%oname \
	--qsci-api-destdir=%_datadir/qt4/qsci3 \
	CFLAGS+="%optflags" CXXFLAGS+="%optflags"
for i in $(find ./ -name Makefile); do
	sed -i 's|lpython3\.2|lpython3.2mu|g' $i
done
for i in $(find ./ -name Makefile); do
	sed -i 's|-Wl,-rpath,|-I|g' $i
done
%make_build
popd
%endif

%install
%if_with python3
pushd ../python3
%makeinstall_std INSTALL_ROOT=%buildroot
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
rm -fR %buildroot%python3_sitelibdir/%oname/uic/port_v2
%endif

%makeinstall_std INSTALL_ROOT=%buildroot
rm -rf %buildroot%python_sitelibdir/%oname/uic/port_v3

#install -m644 ../_tmp_/pyqtconfig.py \
#	%buildroot%python_sitelibdir/%oname/

##wait ##
install -d %buildroot/usr/share/sip/PyQt4/Qsci \
	PyQt-x11-gpl/sip/QtGui
#bzip2 ChangeLog

%files
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%_qt4dir/plugins/designer/libpyqt4.so

%files devel
%dir %_datadir/sip
%_datadir/sip/*
%dir %_datadir/qt4
%_datadir/qt4/qsci

%files doc
%doc doc/*
#doc NEWS README ChangeLog* THANKS
%doc NEWS README THANKS

%files examples
%doc examples

%if_with python3
%files -n python3-module-%oname
%_bindir/*.py3
%python3_sitelibdir/*

%files -n python3-module-%oname-devel
%dir %_datadir/sip3
%_datadir/sip3/*
%dir %_datadir/qt4
%_datadir/qt4/qsci3
%endif

%changelog
