%define oname Pyro4

%def_with python3
%def_with docs

Name:           python-module-%oname
Version:        4.39
Release:        alt2
Summary:        Python Remote Objects
Group:          Development/Python
License:        LGPLv2+
URL:            https://pypi.python.org/pypi/Pyro4/
Source:         Pyro4-%version.tar.gz
BuildArch:      noarch
Packager: Python Development Team <python@packages.altlinux.org>

BuildPreReq: python-devel python-module-sphinx-devel
BuildPreReq: python-module-setuptools-tests
%if_with docs
BuildPreReq: python-module-serpent python3-module-sphinx-devel
%endif #docs
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-serpent
%endif

%py_requires json wsgiref

%description
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 Remote Objects
Group: Development/Python3
%py3_requires json wsgiref

%description -n python3-module-%oname
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

%package -n python3-module-%oname-tests
Summary: Tests for Pyro4 (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

This package contains tests for Pyro4.
%endif

%package tests
Summary: Tests for Pyro4
Group: Development/Python
Requires: %name = %version-%release

%description tests
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

This package contains tests for Pyro4.

%package examples
Summary: Examples for Pyro4
Group: Development/Documentation
BuildArch: noarch

%description examples
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

This package contains examples for Pyro4.

%package docs
Summary: Documentation for for Pyro4
Group: Development/Documentation
BuildArch: noarch

%description docs
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

This package contains documentation for Pyro4.

%package pickles
Summary: Pickles for for Pyro4
Group: Development/Python

%description pickles
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

This package contains pickles for Pyro4.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%if_with docs
%prepare_sphinx docs
ln -s ../objects.inv docs/source
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install

%if_with docs
export PYTHONPATH=%buildroot%python_sitelibdir
ln -s $PWD/docs/objects.inv %buildroot%python_sitelibdir
pushd docs
%make html
%make pickle
popd
rm -f %buildroot%python_sitelibdir/objects.inv
cp -fR build/sphinx/pickle %buildroot%python_sitelibdir/%oname/
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc LICENSE *.txt
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%if_with docs
%exclude %python_sitelibdir/%oname/pickle
%endif #docs
%exclude %python_sitelibdir/%oname/test

%files tests
%python_sitelibdir/%oname/test

%files examples
%doc examples
%doc tests

%if_with docs
%files docs
%doc build/sphinx/html/*

%files pickles
%python_sitelibdir/%oname/pickle
%endif #docs

%if_with python3
%files -n python3-module-%oname
%doc LICENSE *.txt
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/test

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/test
%endif

%changelog
