%define oname aioamqp

%def_without python2
%def_with python3

Name: python-module-%oname
Version: 0.2.1
Release: alt1.git20141217.1.1
Summary: AMQP implementation using asyncio
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/aioamqp/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/Polyconseil/aioamqp.git
Source: %name-%version.tar
BuildArch: noarch

%if_with python2
#BuildPreReq: python-devel python-module-setuptools-tests
#BuildPreReq: python-module-asyncio python-module-nose
#BuildPreReq: python-module-coverage pylint
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-asyncio python3-module-nose
#BuildPreReq: python3-module-coverage pylint-py3
%endif

%py_provides %oname
%py_requires asyncio

# Automatically added by buildreq on Wed Jan 27 2016 (-bi)
# optimized out: python-base python3 python3-base python3-module-logilab-common python3-module-pytest python3-module-setuptools
BuildRequires: pylint-py3 python3-module-coverage python3-module-nose python3-module-setuptools-tests rpm-build-python3

%description
aioamqp library is a pure-Python implementation of the AMQP 0.9.1
protocol.

Built on top on Python's asynchronous I/O support introduced in PEP
3156, it provides an API based on coroutines, making it easy to write
highly concurrent applications.

%package -n python3-module-%oname
Summary: AMQP implementation using asyncio
Group: Development/Python3
%py3_provides %oname
%py3_requires asyncio

%description -n python3-module-%oname
aioamqp library is a pure-Python implementation of the AMQP 0.9.1
protocol.

Built on top on Python's asynchronous I/O support introduced in PEP
3156, it provides an API based on coroutines, making it easy to write
highly concurrent applications.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%if_with python2
%python_build_debug
%endif

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python2
%python_install
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
%if_with python2
python setup.py test
%endif
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%if_with python2
%files
%doc *.rst docs/*.rst examples
%python_sitelibdir/*
%endif

%if_with python3
%files -n python3-module-%oname
%doc *.rst docs/*.rst examples
%python3_sitelibdir/*
%endif

%changelog
