%define oname apptools

%def_without python3

Name:           python-module-%oname
Version:        4.4.0
Release:        alt1.git20150430
Summary:        Enthough Tool Suite Application Tools

Group:          Development/Python
License:        BSD and LGPLv2+
URL:            http://www.enthought.com/
# https://github.com/enthought/apptools.git
Source:        AppTools-%version.tar.gz
Source1:        README.fedora.python-AppTools
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildArch:      noarch
BuildRequires:  python-module-setuptools, python-devel
BuildRequires: unzip python-module-setupdocs python-module-sphinx-devel
BuildPreReq: python-module-traits python-module-wx2.9
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setupdocs python-tools-2to3
%endif
#Requires:       python-module-TraitsGUI, python-module-EnthoughtBase
Requires: python-module-wx < 3.0
%py_requires %oname.help.help_plugin.examples_preferences
%add_python_req_skip examples_preferences

%description
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications. They implement
functionality that is commonly needed by many applications

    * enthought.appscripting: Framework for scripting applications.

    * enthought.help: Provides a plugin for displaying documents and
      examples and running demos in Envisage Workbench applications.

    * enthought.io: Provides an abstraction for files and folders in a
      file system.

    * enthought.naming: Manages naming contexts, supporting non-string
      data types and scoped preferences

    * enthought.permissions: Supports limiting access to parts of an
      application unless the user is appropriately authorised (not
      full-blown security).

and many more.

%if_with python3
%package -n python3-module-%oname
Summary: Enthough Tool Suite Application Tools (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications. They implement
functionality that is commonly needed by many applications

    * enthought.appscripting: Framework for scripting applications.

    * enthought.help: Provides a plugin for displaying documents and
      examples and running demos in Envisage Workbench applications.

    * enthought.io: Provides an abstraction for files and folders in a
      file system.

    * enthought.naming: Manages naming contexts, supporting non-string
      data types and scoped preferences

    * enthought.permissions: Supports limiting access to parts of an
      application unless the user is appropriately authorised (not
      full-blown security).

and many more.
%endif

%package docs
Summary: Documentation for AppTools
Group: Development/Documentation
BuildArch: noarch

%description docs
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications.

This package contains documentation for AppTools.

%package pickles
Summary: Pickles for AppTools
Group: Development/Python

%description pickles
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications.

This package contains pickles for AppTools.

%package tests
Summary: Tests for AppTools
Group: Development/Python
Requires: %name = %EVR
%add_python_req_skip util

%description tests
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications.

This package contains tests for AppTools.

%prep
%setup -n AppTools-%version
#rm -rf AppTools.egg-info
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%prepare_sphinx docs/source

%build
%python_build
%if_with python3
pushd ../python3
for i in $(find ./ -name '*.py'); do
	2to3 -w -n $i
done
%python3_build
popd
%endif

%generate_pickles docs/source docs/source %oname
sphinx-build -E -a -b html -c docs/source -d doctrees docs/source html

%install
%python_install -O1
install -p -m644 %SOURCE1 README.fedora
%if_with python3
pushd ../python3
%python3_install
popd
%endif

# pickles

install -d %buildroot%python_sitelibdir/%oname
cp -fR pickle %buildroot%python_sitelibdir/%oname/

%files
%doc *.txt README.fedora
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/pickle
#_bindir/*
%exclude %python_sitelibdir/%oname/*/test*
%exclude %python_sitelibdir/%oname/*/*/*/example*
%exclude %python_sitelibdir/%oname/*/*/example*
%exclude %python_sitelibdir/%oname/*/*/test*

%files tests
%python_sitelibdir/%oname/*/test*
%python_sitelibdir/%oname/*/*/*/example*
%python_sitelibdir/%oname/*/*/example*
%python_sitelibdir/%oname/*/*/test*

%files docs
%doc examples html

%files pickles
%dir %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle

%if_with python3
%files -n python3-module-%oname
%doc *.txt README.fedora
%python3_sitelibdir/*
%endif

%changelog
