#def_disable check
%def_with python3

%define oname astroid
Name: python-module-%oname
Version: 1.4.4
Release: alt1

Summary: Python Abstract Syntax Tree New Generation
License: LGPLv2.1+
Group: Development/Python

BuildArch: noarch

Url: http://www.logilab.org/project/logilab-astng
# hg clone https://bitbucket.org/logilab/astroid
Source: %name-%version.tar

Provides: python-module-logilab-astng = %version-%release
Obsoletes: python-module-logilab-astng <= 0.24.2

Requires: python-module-logilab-common >= 0.60.0
Requires: python-module-lazy_object_proxy

%setup_python_module %oname
%python_module_declare %python_sitelibdir/logilab

# Automatically added by buildreq on Wed Jan 27 2016 (-bi)
# optimized out: python-base python-devel python-module-egenix-mx-base python-module-kerberos python-module-setuptools python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-unittest python3 python3-base python3-module-setuptools python3-module-six xz
BuildRequires: python-module-logilab-common python-module-pytest python3-module-logilab-common python3-module-pytest rpm-build-python3 time
BuildRequires: python-module-wrapt
#BuildRequires: python-module-logilab-common
#BuildPreReq: python-module-setuptools-tests python-module-six


%{?!_without_check:%{?!_disable_check:BuildRequires: /usr/bin/pytest}}
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-lazy_object_proxy
BuildRequires: python3-module-wrapt
#BuildRequires: python3-devel python3-module-setuptools-tests
#BuildRequires: python3-module-logilab-common /usr/bin/pytest3
#BuildPreReq: python3-module-six
#BuildPreReq: python-tools-2to3
%endif

%py_requires logilab.common six

%description
The aim of this module is to provide a common base representation of
python source code for projects such as pychecker, pyreverse, pylint...
Well, actually the development of this library is essentialy governed by
pylint's needs.
It extends class defined in the compiler.ast [1] module (python <= 2.4)
or in the builtin _ast module (python >= 2.5) with some additional
methods and attributes. Instance attributes are added by a builder
object, which can either generate extended ast (let's call them astng ;)
by visiting an existant ast tree or by inspecting living object. Methods
are added by monkey patching ast classes.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
The aim of this module is to provide a common base representation of
python source code for projects such as pychecker, pyreverse, pylint...
Well, actually the development of this library is essentialy governed by
pylint's needs.
It extends class defined in the compiler.ast [1] module (python <= 2.4)
or in the builtin _ast module (python >= 2.5) with some additional
methods and attributes. Instance attributes are added by a builder
object, which can either generate extended ast (let's call them astng ;)
by visiting an existant ast tree or by inspecting living object. Methods
are added by monkey patching ast classes.

This package contains tests for %oname.

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 Abstract Syntax Tree New Generation
Group: Development/Python3
%py3_requires logilab.common six

Provides: python3-module-logilab-astng = %version-%release
Obsoletes: python3-module-logilab-astng <= 0.24.2

Requires: python3-module-logilab-common >= 0.60.0

%description -n python3-module-%oname
The aim of this module is to provide a common base representation of
python source code for projects such as pychecker, pyreverse, pylint...
Well, actually the development of this library is essentialy governed by
pylint's needs.
It extends class defined in the compiler.ast [1] module (python <= 2.4)
or in the builtin _ast module (python >= 2.5) with some additional
methods and attributes. Instance attributes are added by a builder
object, which can either generate extended ast (let's call them astng ;)
by visiting an existant ast tree or by inspecting living object. Methods
are added by monkey patching ast classes.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
The aim of this module is to provide a common base representation of
python source code for projects such as pychecker, pyreverse, pylint...
Well, actually the development of this library is essentialy governed by
pylint's needs.
It extends class defined in the compiler.ast [1] module (python <= 2.4)
or in the builtin _ast module (python >= 2.5) with some additional
methods and attributes. Instance attributes are added by a builder
object, which can either generate extended ast (let's call them astng ;)
by visiting an existant ast tree or by inspecting living object. Methods
are added by monkey patching ast classes.

This package contains tests for %oname.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
#PYTHONPATH=%buildroot%python_sitelibdir pytest -vv

%if_with python3
PYTHONPATH=%buildroot%python3_sitelibdir pytest3 -vv
%endif

%files
%python_sitelibdir/astroid/
%exclude %python_sitelibdir/astroid/test*
%python_sitelibdir/*.egg-info
%doc ChangeLog README

%files tests
%python_sitelibdir/astroid/test*

%if_with python3
%files -n python3-module-%oname
%doc ChangeLog README
%python3_sitelibdir/astroid/
%exclude %python3_sitelibdir/astroid/test*
%exclude %python3_sitelibdir/astroid/*/test*
%python3_sitelibdir/*.egg-info

%files -n python3-module-%oname-tests
%python3_sitelibdir/astroid/test*
%python3_sitelibdir/astroid/*/test*
%endif

%changelog
