%define oname babel

%def_with python3
%def_with docs
#def_disable check

Name:    python-module-%oname
Version: 2.3.4
Release: alt0.M80P.1
Epoch:   1

Summary: a collection of tools for internationalizing Python applications
License: BSD
Group: Development/Python

Url: http://babel.pocoo.org/

# https://github.com/mitsuhiko/babel.git
Source: %name-%version.tar
Source1: CLDR.tar

BuildArch: noarch
BuildPreReq: python-module-setuptools-tests python-module-sphinx-devel
BuildPreReq: python-module-pytest-cov
%{?!_without_check:%{?!_disable_check:BuildRequires: %py_dependencies setuptools.command.test pytz}}

%setup_python_module babel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-pytest-cov
BuildPreReq: python3-module-pytz
%endif
%py_requires pytz

%description
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.

%if_with python3
%package -n python3-module-%oname
Summary: a collection of tools for internationalizing Python 3 applications
Group: Development/Python3
%py3_requires pytz

%description -n python3-module-%oname
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.
%endif

%prep
%setup -a1
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
python scripts/import_cldr.py CLDR/common
%python_build
%if_with python3
pushd ../python3
python scripts/import_cldr.py CLDR/common
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/pybabel %buildroot%_bindir/pybabel3
%endif

%python_install

%if_with docs
%make -C docs html
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%_bindir/pybabel
%python_sitelibdir/*
%doc AUTHORS CHANGES README.md
%if_with docs
%doc docs/_build/html
%endif

%if_with python3
%files -n python3-module-%oname
%doc AUTHORS CHANGES README.md
%if_with docs
%doc docs/_build/html
%endif
%_bindir/pybabel3
%python3_sitelibdir/*
%endif

%changelog
